import QtQuick 1.0

Dialog {
    id: root

    property alias message: message.text
    property alias acceptButtonText: acceptButton.text
    property alias rejectButtonText: rejectButton.text

    content: Label {
        id: message

        anchors.fill: parent
        
        
        wrapMode: Text.WordWrap
        horizontalAlignment: Text.AlignHCenter
    }

    buttons: [
        Button {
            id: acceptButton

            width: appWindow.inPortrait ? root.width - 20 : textWidth > 150 ? textWidth + 20 : 150
            enabled: text != ""
            onClicked: accept()
        },

        Button {
            id: rejectButton

            width: acceptButton.width
            visible: text != ""
            onClicked: reject()
        }
    ]
}
