import QtQuick 1.0

 Rectangle {
     id: root

     property bool useTheme: true
     property double value: 0

     height: 10
     radius: 5
     gradient: Gradient {
         GradientStop { id: gradient1; position: 0.0; color: root.useTheme ? Settings.gradientColorHigh : "#524e4e" }
         GradientStop { id: gradient2; position: 0.7; color: root.useTheme ? Settings.gradientColor : "black"}
     }
     border.width: 2
     border.color: Settings.activeColor
     opacity: 0.7
     smooth: true
     clip: true


     Rectangle {
         id: highlight


         anchors { left: parent.left; top: parent.top; bottom: parent.bottom }
         width: Math.floor(root.width * value)
         radius: 10
         gradient: Gradient {
             GradientStop { id: gradient3; position: 0.0; color: Qt.lighter(Settings.activeColor, 1.2) }
             GradientStop { id: gradient4; position: 0.7; color: Settings.activeColor }
         }
         smooth: true
     }
 }
