import QtQuick 1.0
import QtWebKit 1.0
import "components"
import "scripts/OAuth.js" as OAuth

Dialog {
    id: root

    function checkUrlForToken() {
        var url = webView.url.toString();
        if (url.split("=")[0] == "http://www.facebook.com/connect/login_success.html#access_token") {
            var facebookToken = url.split("=")[1].split("&")[0];
            if (facebookToken !== "") {
                Settings.setFacebookAccessToken(facebookToken);
            }
            else {
                messages.displayMessage(qsTr("Error obtaining facebook authorisation"));
            }
            accept();
        }
    }

    titleText: qsTr("Facebook authorisation")
    content: Flickable {
        id: webFlicker

        anchors.fill: parent
        contentWidth: webView.width
        contentHeight: webView.height
        boundsBehavior: Flickable.DragOverBounds
        clip: true
        visible: webView.url != ""

        WebView {
            id: webView

            width: 1000
            height: 1000
            preferredWidth: parent.width
            preferredHeight: parent.height
            opacity:(status == WebView.Loading) || (webView.url.toString() == "") || (webView.url.toString().slice(0, 25) == "http://www.cutetube.co.uk") ? 0 : 1
            url: "https://graph.facebook.com/oauth/authorize?"
                 + "client_id=" + Sharing.facebookId
                 + "&redirect_uri=http://www.facebook.com/connect/login_success.html"
                 + "&type=user_agent&display=popup&scope=publish_stream,offline_access"
            onUrlChanged: checkUrlForToken()

            Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 300 } }
        }
    }

    BusyDialog {
        id: busyDialog

        property bool show : false

        anchors.centerIn: parent
        visible: (busyDialog.show) || (webView.progress < 1)
    }
}
