import QtQuick 1.0
import "components"
import "scripts/dailymotion.js" as DM

Page {
    id: root

    property bool autoLoad: true
    property string groupFeed

    function setGroupFeed(feed) {
        groupFeed = feed;
        DM.getGroups(feed);
    }

    function goToGroupVideos(group) {
        pageStack.push(Qt.resolvedUrl("DMGroupVideosPage.qml"));
        pageStack.currentPage.title = group.name;
        pageStack.currentPage.setGroup(group.id);
    }

    title: qsTr("Groups")

    Connections {
        target: groupModel
        onLoadingChanged: {
            if ((autoLoad) && (!groupModel.loading) && (!groupModel.error) && (groupModel.moreResults)) {
                DM.getGroups(groupFeed);
            }
        }
    }

    ListView {
        id: groupList

        anchors { fill: parent; topMargin: pageStack.currentPage == root ? titleArea.height : 0 }
        boundsBehavior: Flickable.DragOverBounds
        highlightRangeMode: ListView.StrictlyEnforceRange
        clip: true
        onCurrentIndexChanged: {
            if ((!autoLoad) && (groupList.count - groupList.currentIndex == 1) && (!groupModel.loading) && (groupModel.moreResults)) {
                DM.getGroups(groupFeed);
            }
        }
        model: ListModel {
            id: groupModel

            property bool loading : false
            property bool moreResults: false
            property bool error: false
            property int page: 1
        }
        delegate: DMPlaylistDelegate {
            id: delegate

            onClicked: goToGroupVideos(groupModel.get(index))
        }
        footer: Item {
            id: footer

            width: groupList.width
            height: 80
            visible: groupModel.loading
            opacity: footer.visible ? 1 : 0

            BusyDialog {
                anchors.centerIn: footer
                opacity: footer.opacity
            }
        }

        ScrollBar {}
    }

    Label {
        anchors.centerIn: groupList
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No groups found")
        visible: (!groupModel.loading) && (groupModel.count === 0)
    }
}
