import QtQuick 1.0

Item {
    id: root

    property int stepSize: 10
    property int minimum: 0
    property int maximum: 100
    property int value: 0

    Rectangle {
        id: background

        height: 10
        radius: 5
        gradient: Gradient {
            GradientStop { id: gradient1; position: 0.0; color: Settings.gradientColorHigh }
            GradientStop { id: gradient2; position: 0.7; color: Settings.gradientColor }
        }
        border.width: 2
        border.color: Settings.activeColor
        opacity: 0.7
        smooth: true
        clip: true


        Rectangle {
            id: highlight


            anchors { left: parent.left; top: parent.top; bottom: parent.bottom }
            width: Math.floor(parent.width * value)
            radius: 10
            gradient: Gradient {
                GradientStop { id: gradient3; position: 0.0; color: Qt.lighter(Settings.activeColor, 1.2) }
                GradientStop { id: gradient4; position: 0.7; color: Settings.activeColor }
            }
            smooth: true
        }
    }

    Button {
        id: button

        width: 50
        height: 50
        x: value - 25
        anchors.verticalCenter: parent.verticalCenter

        Behavior on x { SmoothedAnimation { velocity: 200 } }
    }
}
