#ifndef XTUBE_H
#define XTUBE_H

#include <QObject>
#include <QVariantList>
#include <QNetworkAccessManager>
#include <QNetworkReply>

class XTube : public QObject
{
    Q_OBJECT

    Q_PROPERTY(bool loading
               READ getLoading
               NOTIFY loadingChanged)
public:
    explicit XTube(QObject *parent = 0);

    Q_INVOKABLE void search(QString query);
    Q_INVOKABLE void getMoreVideos();
    Q_INVOKABLE void getYouPornVideoUrl(const QString &url);
    Q_INVOKABLE void getXVideosVideoUrl(const QString &url);
    void setNetworkAccessManager(QNetworkAccessManager *manager);
    bool getLoading();

private slots:
    void parseYouPornPage();
    void parseYouPornVideoPage();
    void parseXVideosPage();
    void parseXVideosVideoPage();

private:
    QUrl getYouPornSearchUrl(QString query);
    QUrl getXVideosSearchUrl(QString query);
    void getVideos();

signals:
    void gotVideoUrl(const QString &videoUrl);
    void gotVideos(const QVariantList &videos);
    void alert(const QString &message);
    void videoUrlError();
    void loadingChanged();

private:
    QString searchQuery;
    int pageNumber;
    QNetworkAccessManager *nam;
    QNetworkReply *xvReply;
    QNetworkReply *ypReply;
};

#endif // XTUBE_H
