#ifndef UTILS_H
#define UTILS_H

#include <QObject>
#include <QProcess>
#include <QVariantList>
//#include <QSystemInfo>
//#include <QSystemDeviceInfo>

class QWidget;

//using namespace QtMobility;

#include "qmlapplicationviewer.h"

class Utils : public QObject {
    Q_OBJECT

    Q_PROPERTY(QString currentTime
               READ getCurrentTime
               NOTIFY currentTimeChanged)
//    Q_PROPERTY(int batteryLevel
//               READ getBatteryLevel
//               NOTIFY batteryLevelChanged)

public:
    explicit Utils(QObject *parent = 0);

    void setView(QmlApplicationViewer* view);
    QString getCurrentTime() const;
//    int getBatteryLevel() const;

public slots:

    QVariantList getInstalledMediaPlayers() const;
    bool widgetInstalled() const;
    void setMediaPlayer(const QString &player);
    void doNotDisturb(bool preventDisturb);
    void toggleState();
    void minimize();
    void playVideo(const QString &url);
    bool pathExists(const QString &path);
    QString getDocsDirectory() const;
//    QString getInstalledQtVersion() const;

private:
    QmlApplicationViewer *viewer;
    QString mediaPlayer;
//    QSystemInfo *systemInfo;
//    QSystemDeviceInfo *deviceInfo;

signals:
    void alert(const QString &message);
    void currentTimeChanged();
//    void batteryLevelChanged();
};

#endif // UTILS_H
