import QtQuick 1.0
import "components"

Page {
    id: root

    title: qsTr("Settings") + " - " + qsTr("Search")

    Flickable {
        id: flicker

        anchors { fill: parent; topMargin: titleArea.height + 10 }
        contentWidth: parent.width
        contentHeight: col1.height
        flickableDirection: Flickable.VerticalFlick
        clip: true

        Column {
            id: col1

            anchors { top: parent.top; left: parent.left; right: parent.right }
            spacing: 20

            Row {
                x: 10
                spacing: parent.width - (children[0].width + children[1].width + 20)

                Text {
                    property string isOn: safeSwitch.checked ? qsTr("on") : qsTr("off")

                    height: safeSwitch.height
                    color: _TEXT_COLOR
                    verticalAlignment: Text.AlignVCenter
                    font.bold: true
                    text: qsTr("Safe search is") + " " + isOn
                }

                Switch {
                    id: safeSwitch

                    Component.onCompleted: {
                        checked = Settings.safeSearch
                    }
                    onCheckedChanged: Settings.safeSearch = checked
                }
            }

            Button {
                x: Math.floor((parent.width / 2) - (width  / 2))
                text: qsTr("Clear previous searches")
                enabled: Settings.recentSearches.length > 0
                onClicked: Settings.recentSearches = []
            }
        }
    }
}
