import QtQuick 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator

QueryDialog {
    id: root

    function addUpload() {
        var uploadItem = {};
        uploadItem["youtube"] = true;
        uploadItem["filePath"] = fileSelector.currentValue;
        uploadItem["title"] = titleInput.text;
        uploadItem["description"] = descriptionInput.text;
        uploadItem["tags"] = tagsInput.text;
        uploadItem["category"] = categorySelector.currentValue;
        uploadItem["private"] = checkbox.checked;
        uploadItem["status"] = Settings.defaultTransferStatus;
        uploadItem["type"] = transfers._UPLOAD;
        uploadItem["eta"] = undefined;
        uploadItem["progress"] = undefined;
        uploadItem["size"] = undefined;
        uploadItem["reason"] = qsTr("Reason unknown");
        transfers.appendTransfer(uploadItem);
        messages.displayMessage(messages._VIDEO_UPLOAD_ADDED);
    }

    function showFileBrowserDialog() {
        var browser = ObjectCreator.createObject(Qt.resolvedUrl("FileBrowserDialog.qml"), appWindow);
        browser.titleText = fileSelector.title;
        browser.isChild = true;
        browser.startFolder = Utils.getDocsDirectory();
        browser.showFiles = true;
        browser.fileChosen.connect(setFile);
        browser.closed.connect(root.close);
        browser.rejected.connect(raiseOpacity);
        browser.opened.connect(lowerOpacity);
        browser.open();
    }

    function setFile(filePath) {
        raiseOpacity();
        fileSelector.currentValue = filePath;
        titleInput.text = filePath.split("/").pop().replace(/\.[a-zA-Z0-9]{3,4}$/, "");
    }

    onAccepted: addUpload()
    titleText: qsTr("Video upload")
    rejectButtonText: qsTr("Cancel")
    acceptButtonText: ((titleInput.text == "") || (fileSelector.currentValue == "")) ? "" : qsTr("Upload")
    content: Item {
        anchors.fill: parent

        Flickable {
            id: flicker

            anchors.fill: parent
            contentWidth: width
            contentHeight: col1.height + 20
            flickableDirection: Flickable.VerticalFlick
            clip: true

            Column {
                id: col1

                anchors { top: parent.top; left: parent.left; right: parent.right }
                spacing: 20

                SelectionItemBasic {
                    id: fileSelector

                    property string currentValue: ""

                    title: qsTr("Video file")
                    subTitle: currentValue == "" ? qsTr("None chosen") : currentValue.slice(currentValue.lastIndexOf("/") + 1)
                    onClicked: showFileBrowserDialog()
                }

                SelectionItem {
                    id: categorySelector

                    title: qsTr("Category")
                    model: ListModel {
                        ListElement { name: QT_TR_NOOP("Cars & Vehicles"); value: "Autos" }
                        ListElement { name: QT_TR_NOOP("Comedy"); value: "Comedy" }
                        ListElement { name: QT_TR_NOOP("Education"); value: "Education" }
                        ListElement { name: QT_TR_NOOP("Entertainment"); value: "Entertainment" }
                        ListElement { name: QT_TR_NOOP("Film"); value: "Film" }
                        ListElement { name: QT_TR_NOOP("Gaming"); value: "Games" }
                        ListElement { name: QT_TR_NOOP("Music"); value: "Music" }
                        ListElement { name: QT_TR_NOOP("News & Politics"); value: "News" }
                        ListElement { name: QT_TR_NOOP("Non-profits & Activism"); value: "Nonprofit" }
                        ListElement { name: QT_TR_NOOP("People"); value: "People" }
                        ListElement { name: QT_TR_NOOP("Pets & Animals"); value: "Animals" }
                        ListElement { name: QT_TR_NOOP("Science & Technology"); value: "Tech" }
                        ListElement { name: QT_TR_NOOP("Sport"); value: "Sports" }
                        ListElement { name: QT_TR_NOOP("Style"); value: "Howto" }
                        ListElement { name: QT_TR_NOOP("Travel & Events"); value: "Travel" }
                    }
                    initialValue: "Entertainment"
                    isChild: true
                    onOpened: lowerOpacity()
                    onAccepted: raiseOpacity()
                    onClosed: root.close()
                }

                Text {
                    x: 10
                    color: _TEXT_COLOR
                    font.bold: true
                    text: qsTr("Title")
                }

                TextField {
                    id: titleInput

                    x: 10
                    width: parent.width - 20
                    Keys.onReturnPressed: descriptionInput.focus = true
                    Keys.onEnterPressed: descriptionInput.focus = true
                }

                Text {
                    x: 10
                    color: _TEXT_COLOR
                    font.bold: true
                    text: qsTr("Description")
                }

                TextArea {
                    id: descriptionInput

                    x: 10
                    width: parent.width - 20
                }

                Text {
                    x: 10
                    color: _TEXT_COLOR
                    font.bold: true
                    text: qsTr("Tags (separated by commas)")
                }

                TextField {
                    id: tagsInput

                    x: 10
                    width: parent.width - 20
                }

                CheckBox {
                    id: checkbox

                    x: 10
                    text: qsTr("Private?")
                }
            }
        }
    }
}
