import QtQuick 1.0

Item {
    id: root

    property bool checked: false
    property alias text: label.text

    width: 60 + label.width
    height: 50

    Rectangle {
        id: border

        width: 50
        height: 50
        color: _BACKGROUND_COLOR
        border.width: 2
        border.color: Settings.activeColor
        radius: 5
        opacity: 0.5
    }

    Image {
        width: 35
        height: 35
        anchors.centerIn: border
        source: Settings.appTheme == "light" ? "../images/done.png" : "../images/done-white.png"
        smooth: true
        visible: checked
    }

    Text {
        id: label

        anchors { left: border.right; leftMargin: 10; verticalCenter: root.verticalCenter }
        font.pixelSize: _STANDARD_FONT_SIZE
        color: _TEXT_COLOR
        verticalAlignment: Text.AlignVCenter
    }

    MouseArea {
        id: mouseArea

        anchors.fill: root
        onClicked: checked = !checked
    }
}
