import QtQuick 1.0
import "components"

QueryDialog {
    id: root

    property string site: "youtube"

    function createPlaylist() {
        toggleBusy(true);
        if (site == "youtube") {
            YouTube.createPlaylist(titleInput.text, descriptionInput.text, checkbox.checked);
        }
        else {
            Dailymotion.createPlaylist(titleInput.text);
        }
    }

    titleText: qsTr("New playlist")
    acceptButtonText: titleInput.text == "" ? "" : qsTr("Create")
    rejectButtonText: qsTr("Cancel")
    onAccepted: createPlaylist()
    content: Flickable {
        id: flicker

        anchors.fill: parent
        contentWidth: parent.width
        contentHeight: col1.height + 20
        flickableDirection: Flickable.VerticalFlick
        clip: true

        Column {
            id: col1

            z: 101
            anchors { top: parent.top; left: parent.left; right: parent.right; margins: 10 }
            spacing: 20

            Text {
                font.bold: true
                color: _TEXT_COLOR
                text: qsTr("Title")
            }

            TextField {
                id: titleInput

                width: parent.width
            }

            Text {
                font.bold: true
                color: _TEXT_COLOR
                text: qsTr("Description")
                visible: site == "youtube"
            }

            TextArea {
                id: descriptionInput

                width: parent.width
                visible: site == "youtube"
            }

            CheckBox {
                id: checkbox

                text: qsTr("Private?")
                visible: site == "youtube"
            }
        }
    }

    MouseArea {
        z: -1
        anchors.fill: parent
    }
}
