#include <QtGui/QApplication>
#include <QDeclarativeContext>
#include <QtDeclarative>
#include <QTranslator>
#include "qmlapplicationviewer.h"
#include "youtube.h"
#include "dailymotion.h"
#include "database.h"
#include "downloadmanager.h"
#include "settings.h"
#include "folderlistmodel.h"
#include "utils.h"
#include "xtube.h"

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    QmlApplicationViewer viewer;

    YouTube yt;
    Dailymotion daily;
    XTube xt;
    Database db;
    DownloadManager dm;
    Settings settings;
    Utils ut;
    ut.setView(&viewer);
    QNetworkAccessManager *manager = new QNetworkAccessManager();
    yt.setNetworkAccessManager(manager);
    daily.setNetworkAccessManager(manager);
    xt.setNetworkAccessManager(manager);
    dm.setNetworkAccessManager(manager);

    QObject::connect(&app, SIGNAL(aboutToQuit()), &settings, SLOT(saveSettings()));
    QObject::connect(&settings, SIGNAL(monitorClipboardChanged(bool)), &yt, SLOT(setMonitorClipboard(bool)));
    QObject::connect(&settings, SIGNAL(youtubeUsernameChanged(QString)), &yt, SLOT(setUsername(QString)));
    QObject::connect(&settings, SIGNAL(youtubeAccessTokenChanged(QString)), &yt, SLOT(setAccessToken(QString)));
    QObject::connect(&settings, SIGNAL(dailymotionAccountChanged(QString,QString,QString,int)), &daily, SLOT(setAccount(QString,QString,QString,int)));
    QObject::connect(&settings, SIGNAL(youtubeDownloadQualityChanged(QString)), &dm, SLOT(setYouTubeDownloadQuality(QString)));
    QObject::connect(&settings, SIGNAL(downloadPathChanged(QString)), &dm, SLOT(setDownloadPath(QString)));
    QObject::connect(&settings, SIGNAL(xtubeDownloadPathChanged(QString)), &dm, SLOT(setXTubeDownloadPath(QString)));
    QObject::connect(&settings, SIGNAL(mediaPlayerChanged(QString)), &ut, SLOT(setMediaPlayer(QString)));
    QObject::connect(&settings, SIGNAL(orientationChanged(QString)), &viewer, SLOT(setScreenOrientation(QString)));
    QObject::connect(&yt, SIGNAL(signedOut()), &settings, SLOT(clearYouTubeAccount()));
    QObject::connect(&yt, SIGNAL(gotVideoUrl(QString)), &ut, SLOT(playVideo(QString)));
    QObject::connect(&daily, SIGNAL(gotVideoUrl(QString)), &ut, SLOT(playVideo(QString)));
    QObject::connect(&daily, SIGNAL(signedIn(QString,QString,QString,int)), &settings, SLOT(setDailymotionAccount(QString,QString,QString,int)));
    QObject::connect(&daily, SIGNAL(signedOut()), &settings, SLOT(clearDailymotionAccount()));
    QObject::connect(&xt, SIGNAL(gotVideoUrl(QString)), &ut, SLOT(playVideo(QString)));

    qmlRegisterType<QDeclarativeFolderListModel>("Models",1,0,"FolderListModel");

    QDeclarativeContext *context = viewer.rootContext();
    context->setContextProperty("YouTube", &yt);
    context->setContextProperty("Dailymotion", &daily);
    context->setContextProperty("XTube", &xt);
    context->setContextProperty("DownloadManager", &dm);
    context->setContextProperty("Database", &db);
    context->setContextProperty("Settings", &settings);
    context->setContextProperty("Utils", &ut);
    context->setContextProperty("MainWindow", &viewer);
    settings.restoreSettings();

    QString locale = settings.getLanguage();
    QTranslator translator;
    if (translator.load(QString("/opt/qmltube/qml/qmltube/i18n/qml_" + locale))) {
        app.installTranslator(&translator);
    }

    viewer.setWindowTitle(QString("cuteTube-QML"));
    viewer.engine()->addImportPath(QString("/opt/qtm12/imports"));
    viewer.engine()->addPluginPath(QString("/opt/qtm12/plugins"));
    viewer.setMainQmlFile(QLatin1String("qml/qmltube/main.qml"));
    viewer.showFullScreen();

    return app.exec();
}
