#include "database.h"
#include <QFile>
#include <QtSql/QSqlQuery>
#include <QtSql/QSqlRecord>
#include <QDateTime>
#include <QDir>
#include <QDesktopServices>
#include <QDebug>

Database::Database(QObject *parent) :
    QObject(parent) {
    QDir dbPath;
    dbPath.mkpath(QString("/home/user/cuteTube-QML/"));
    database = QSqlDatabase::addDatabase("QSQLITE");
    database.setDatabaseName(QString("/home/user/cuteTube-QML/cuteTube-QML.sqlite"));
    initialize();
}

Database::~Database() {

}

void Database::initialize() {
    database.open();
    database.exec("DROP TABLE IF EXISTS savedDownloads");
    database.exec("CREATE TABLE IF NOT EXISTS downloads (videoId TEXT UNIQUE, title TEXT, thumbnail TEXT, convertToAudio INTEGER, youtube INTEGER, dailymotion INTEGER, youporn INTEGER)");
    database.exec("ALTER TABLE downloads ADD COLUMN xvideos INTEGER");
    database.close();
}

bool Database::storeDownload(const QVariantMap &video) {
    if (!database.isOpen()) {
        database.open();
    }
    bool querySuccessful;
    QSqlQuery query;
    query.prepare("INSERT OR REPLACE INTO downloads VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    query.addBindValue(video.value("videoId").toString());
    query.addBindValue(video.value("title").toString());
    query.addBindValue(video.value("thumbnail").toString());
    query.addBindValue(video.value("convertToAudio").toInt());
    query.addBindValue(video.value("youtube").toInt());
    query.addBindValue(video.value("dailymotion").toInt());
    query.addBindValue(video.value("youporn").toInt());
    query.addBindValue(video.value("xvideos").toInt());
    querySuccessful = query.exec();
    database.close();
    return querySuccessful;
}

bool Database::removeStoredDownload(const QString &videoId) {
    if (!database.isOpen()) {
        database.open();
    }
    bool querySuccessful;
    QSqlQuery query;
    query.prepare("DELETE FROM downloads WHERE videoId = ?");
    query.addBindValue(videoId);
    querySuccessful = query.exec();
    database.close();
    return querySuccessful;
}

QVariantList Database::getStoredDownloads() {
    if (!database.isOpen()) {
        database.open();
    }
    QSqlQuery query;
    QSqlRecord record;
    QVariantMap downloadItem;
    QVariantList downloads;
    query.exec("SELECT videoId, title, thumbnail, convertToAudio, youtube, dailymotion, youporn, xvideos FROM downloads");
    record = query.record();
    if (record.count() > 0) {
        while (query.next()) {
            downloadItem.insert("videoId", query.value(0));
            downloadItem.insert("title", query.value(1));
            downloadItem.insert("thumbnail", query.value(2));
            downloadItem.insert("convertToAudio", query.value(3));
            downloadItem.insert("youtube", query.value(4));
            downloadItem.insert("dailymotion", query.value(5));
            downloadItem.insert("youporn", query.value(6));
            downloadItem.insert("xvideos", query.value(7));
            downloadItem.insert("status", QString("paused"));
            downloads.append(downloadItem);
        }
    }
    database.close();
    return downloads;
}

void Database::deleteArchiveVideos(const QStringList &videos) {
    int deleted = 0;
    QString message;
    foreach (QString path, videos) {
        if (QFile::remove(path)) {
            QFile::remove(path.left(path.lastIndexOf("/")) + "/.thumbnails/" + path.split("/").last().replace(".mp4", ".jpg"));
            deleted ++;
        }
    }
    if (deleted == videos.size()) {
        message = tr("Videos deleted successfully");
    }
    else {
        message = tr("Some videos could not be deleted");
    }
    emit archiveVideosDeleted();
    emit alert(message);
}
