#include "xtube.h"
#include <QNetworkRequest>
#include <QStringList>
#include <QRegExp>

XTube::XTube(QObject *parent) :
    QObject(parent), nam(0), yjReply(0), ypReply(0)
{    
}

void XTube::setNetworkAccessManager(QNetworkAccessManager *manager) {
    nam = manager;
}

bool XTube::getLoading() {
    bool loading;
    if ((yjReply == 0) || (ypReply == 0)) {
        loading = false;
    }
    else {
        loading = (yjReply->isRunning()) || (ypReply->isRunning());
    }
    return loading;
}

void XTube::search(QString query) {
    searchQuery = query;
    pageNumber = 1;
    getVideos();
}

void XTube::getVideos() {
    QUrl yjUrl = getYouJizzSearchUrl(searchQuery);
    QUrl ypUrl = getYouPornSearchUrl(searchQuery);
    QNetworkRequest yjRequest(yjUrl);
    QNetworkRequest ypRequest(ypUrl);
    yjReply = nam->get(yjRequest);
    ypReply = nam->get(ypRequest);
    connect(yjReply, SIGNAL(finished()), this, SLOT(parseYouJizzPage()));
    connect(ypReply, SIGNAL(finished()), this, SLOT(parseYouPornPage()));
    emit loadingChanged();
}

void XTube::getMoreVideos() {
    pageNumber++;
    getVideos();
}

QUrl XTube::getYouJizzSearchUrl(QString query) {
    return QUrl(QString("http://m.youjizz.com/search/" + query.replace(QString(" "), QString("%20")) + "/page" + QByteArray::number(pageNumber) + ".html"));
}

QUrl XTube::getYouPornSearchUrl(QString query) {
    return QUrl(QString("http://www.youporn.com/search?query=" + query.replace(QString(" "), QString("%20")) + "&page=" + QByteArray::number(pageNumber)));
}

void XTube::parseYouJizzPage() {
    emit loadingChanged();

    QVariantMap video;
    QVariantList videos;
    QString response(yjReply->readAll());
    QStringList results = response.split("<div class=\"img\">");
    results.takeFirst();
    QRegExp rx;
    int pos;
    foreach (QString result, results) {
        rx.setPattern("[\\w:\\/\\d\\.]+(?=\")");
        pos = rx.indexIn(result);
        video.insert("videoId", rx.cap());
        rx.setPattern("[^\".]+(?=\"\\sname)");
        pos = rx.indexIn(result);
        QString title = rx.cap();
        video.insert("title", title);
        video.insert("name", title);
        rx.setPattern("(\\d+:\\d+)(?=<\\/span)");
        pos = rx.indexIn(result);
        video.insert("duration", rx.cap());
        rx.setPattern("(\\d+){3,}(?=<\\/span)");
        pos = rx.indexIn(result);
        video.insert("viewCount", rx.cap());
        rx.setPattern("(\\d\\.\\d)(?=\\/)");
        pos = rx.indexIn(result);
        video.insert("rating", rx.cap().toDouble());
        rx.setPattern("[\\w:\\/\\d\\.-]+(?=\"\\salt)");
        pos = rx.indexIn(result);
        video.insert("thumbnail", rx.cap());
        video.insert("youjizz", true);
        videos.append(video);
    }
    emit gotVideos(videos);
}

void XTube::parseYouPornPage() {
    emit loadingChanged();

    QVariantMap video;
    QVariantList videos;
    QString response(ypReply->readAll());
    QStringList results = response.split("<img id=\"thumb");
    results.takeFirst();
    QRegExp rx;
    int pos;
    foreach (QString result, results) {
        rx.setPattern("[\\w\\/\\d-]+(?=\\/\\?)");
        pos = rx.indexIn(result);
        QStringList url = rx.cap().split("/", QString::SkipEmptyParts);
        QString videoId;
        if (url.size() > 2) {
            videoId = "http://mobile.youporn.com/video/show/title/" + url.at(2) + "/id/" + url.at(1);
        }
        video.insert("videoId", videoId);
        rx.setPattern("[^>.]+(?=<\\/a><\\/h1>)");
        pos = rx.indexIn(result);
        QString title = rx.cap();
        video.insert("title", title);
        video.insert("name", title);
        rx.setPattern("(\\d+<span>:<\\/span>\\d+)(?=<\\/h2)");
        pos = rx.indexIn(result);
        video.insert("duration", rx.cap().replace(QRegExp("(<span>|<\\/span>)"), ""));
        rx.setPattern("(\\d+,\\d+)(?=\\s<span>views)");
        pos = rx.indexIn(result);
        video.insert("viewCount", rx.cap().replace(",", ""));
        rx.setPattern("(\\d\\.\\d{1,2})(?=<span>)");
        pos = rx.indexIn(result);
        video.insert("rating", rx.cap().toDouble());
        rx.setPattern("[\\w:\\/\\d\\.-]+(?=\"\\snum)");
        pos = rx.indexIn(result);
        video.insert("thumbnail", rx.cap());
        video.insert("youporn", true);
        videos.append(video);
    }
    emit gotVideos(videos);
}

void XTube::getYouPornVideoUrl(const QString &url) {
    QUrl ypUrl(url);
    QNetworkRequest request(ypUrl);
    QNetworkReply *reply = nam->get(request);
    connect(reply, SIGNAL(finished()), this, SLOT(parseYouPornVideoPage()));
}

void XTube::parseYouPornVideoPage() {
    QNetworkReply* reply = qobject_cast<QNetworkReply*>(sender());
    if (!reply) {
        emit videoUrlError();
        return;
    }

    QString response(reply->readAll());
    QStringList results = response.split("\"play_video\"><a href=\"");
    results.takeFirst();
    if (!results.isEmpty()) {
        QString videoUrl = results.takeFirst().split('"').first().replace("amp;", "");
        if (videoUrl.startsWith("http")) {
            emit gotVideoUrl(videoUrl);
        }
        else {
            emit videoUrlError();
        }
    }
    else {
        emit videoUrlError();
    }
    reply->deleteLater();
}
