import QtQuick 1.0

Item {
    id: root

    property alias text: label.text
    property string iconSource
    property bool checked

    signal clicked

    width: Math.floor(parent.width / parent.children.length)
    height: parent.height

    Image {
        id: icon

        anchors.centerIn: parent
        width: 40
        height: 40
        smooth: true
        source: iconSource == "" ? "" : "../" + iconSource
        sourceSize.width: width
        sourceSize.height: height
        visible: source != ""
        opacity: mouseArea.pressed ? 0.5 : 1
    }

    Text {
        id: label

        anchors { fill: parent; margins: 2 }
        elide: Text.ElideRight
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        color: checked ? Settings.activeColor : _TEXT_COLOR
        font.pixelSize: _STANDARD_FONT_SIZE
        visible: text != ""
        opacity: mouseArea.pressed ? 0.5 : 1
    }

    Rectangle {
        width: 1
        height: parent.height - 20
        anchors { right: parent.right; verticalCenter: parent.verticalCenter }
        color: Settings.activeColor
        opacity: 0.7
        visible: root.parent.children[root.parent.children.length - 1] != root
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: root.clicked()
    }
}
