import QtQuick 1.0
import "components"
import "scripts/dateandtime.js" as DT

Item {
    id: delegate

    property bool checked

    signal clicked

    width: parent.width
    height: 180

    ListHighlight {
        visible: (mouseArea.pressed) || (delegate.checked)
    }

    Text {
        id: titleText

        height: 90
        anchors { left: frame.right; leftMargin: 5; right: transferIcon.left; rightMargin: 5; top: frame.top }
        wrapMode: Text.WordWrap
        verticalAlignment: Text.AlignTop
        font.bold: true
        color: _TEXT_COLOR
        clip: true
        text: title
    }

    Image {
        id: frame

        z: 1
        width: 122
        height: 92
        anchors { top: delegate.top; left: delegate.left; margins: 5 }
        source: "images/frame.png"
        sourceSize.width: width
        sourceSize.height: height
        smooth: true

        Image {
            id: thumb

            z: -1
            anchors.fill: frame
            source: type == transfers._DOWNLOAD ? thumbnail : Settings.appTheme == "light" ? "images/video.png" : "images/video-white.png"
            smooth: true
            onStatusChanged: if (thumb.status == Image.Error) thumb.source = Settings.appTheme == "light" ? "images/video.png" : "images/video-white.png";
        }
    }

    Image {
        id: convertIcon

        anchors { bottom: transferIcon.top; bottomMargin: 5; horizontalCenter: transferIcon.horizontalCenter }
        source: Settings.appTheme == "light" ? "images/convert.png" : "images/convert-white.png"
        visible: (type == transfers._DOWNLOAD) && (convertToAudio) ? true : false
    }

    Image {
        id: transferIcon

        anchors { bottom: sizeText.top; bottomMargin: 5; horizontalCenter: sizeText.horizontalCenter }
        source: Settings.appTheme == "light" ? "images/transfer-" + type + ".png" : "images/transfer-" + type + "-white.png"
    }

    Text {
        id: sizeText

        anchors { bottom: progressBar.top; right: parent.right; margins: 5 }
        font.pixelSize: _SMALL_FONT_SIZE
        color: _TEXT_COLOR
        text: !size ? "0000" : Math.round(size / 1000000) + "MB"
        opacity: !size ? 0 : 1
    }

    Row {
        id: infoRow

        anchors { left: parent.left; bottom: progressBar.top; margins: 5 }

        Text {
            id: statusText

            font.pixelSize: _SMALL_FONT_SIZE
            color: (status == transfers._IN_PROGRESS) ? Settings.activeColor : (status == transfers._FAILED) ? "red" : "#4d4d4d"
            text: transfers.statusDict[status]
        }

        Text {
            id: etaText

            font.pixelSize:  _SMALL_FONT_SIZE
            color: statusText.color
            text: (status == transfers._FAILED) ? ": " + reason : !eta ? "" : ": " + DT.getDuration(eta) + " " + qsTr("Remaining")
            visible: (status == transfers._IN_PROGRESS) || (status == transfers._FAILED)
        }
    }

    ProgressBar {
        id: progressBar

        anchors { left: parent.left; right: parent.right; bottom: parent.bottom; margins: 5 }
        value: !progress ? 0.0 : progress
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: parent.clicked()
    }
}

