import QtQuick 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    function goToPlaylistVideos(playlist) {
        pageStack.push(Qt.resolvedUrl("DMPlaylistVideosPage.qml"));
        pageStack.currentPage.setPlaylist(playlist);
    }

    function showNewPlaylistDialog() {
        var playlistDialog = ObjectCreator.createObject(Qt.resolvedUrl("NewPlaylistDialog.qml"), appWindow);
        playlistDialog.site = "dailymotion";
        playlistDialog.open();
    }

    title: qsTr("My Playlists")
    tools: Menu {

        menuItems: MenuItem {
            text: qsTr("New playlist")
            onClicked: showNewPlaylistDialog()
        }
    }

    ContextMenu {
        id: contextMenu

        menuItems: [

            ContextMenuItem {
                text: qsTr("View")
                onClicked: goToPlaylistVideos(ObjectCreator.cloneObject(dailymotionPlaylistModel.get(playlists.selectedIndex)))
            },

            ContextMenuItem {
                text: qsTr("Delete")
                onClicked: {
                    toggleBusy(true);
                    Dailymotion.deletePlaylist(dailymotionPlaylistModel.get(playlists.selectedIndex).id);
                }
            }
        ]
    }

    ListView {
        id: playlists

        property int selectedIndex

        anchors.fill: parent
        boundsBehavior: Flickable.DragOverBounds
        highlightRangeMode: ListView.StrictlyEnforceRange
        clip: true
        model: dailymotionPlaylistModel
        delegate: DMPlaylistDelegate {
            id: delegate

            onClicked: goToPlaylistVideos(ObjectCreator.cloneObject(dailymotionPlaylistModel.get(index)))
            onPressAndHold: {
                playlists.selectedIndex = index;
                contextMenu.titleText = name;
                contextMenu.open();
            }
        }
        footer: Item {
            id: footer

            width: playlists.width
            height: 80
            visible: dailymotionPlaylistModel.loading
            opacity: footer.visible ? 1 : 0

            BusyDialog {
                anchors.centerIn: footer
                opacity: footer.opacity
            }
        }

        ScrollBar {}
    }

    Text {
        anchors.centerIn: playlists
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No playlists found")
        visible: (!dailymotionPlaylistModel.loading) && (dailymotionPlaylistModel.count === 0)
    }
}
