import QtQuick 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator

SelectionDialog {
    id: categorySelector

    function showCategoryVideos(category) {
        pageStack.push(Qt.resolvedUrl("VideoListPage.qml"));
        if (category.youtube == "MostRecent") {
            pageStack.currentPage.setVideoFeeds({ "site": Settings.defaultSite, "youtube": _MOST_RECENT_FEED, "dailymotion": _DM_MOST_RECENT_FEED });
        }
        else if (category.youtube == "MostViewed") {
            pageStack.currentPage.setVideoFeeds({ "site": Settings.defaultSite, "youtube": _MOST_VIEWED_FEED, "dailymotion": _DM_MOST_VIEWED_FEED });
        }
        else {
            pageStack.currentPage.setVideoFeeds({ "site": Settings.defaultSite, "youtube": _CATEGORY_FEED + category.youtube + "&orderby=published", "dailymotion": _DM_CATEGORY_FEED + category.dailymotion });
        }
        pageStack.currentPage.title = category.name;
    }

    titleText: qsTr("Categories")
    model: ListModel {
        ListElement { name: QT_TR_NOOP("Cars & Vehicles"); youtube: "Autos"; dailymotion: "auto" }
        ListElement { name: QT_TR_NOOP("Comedy"); youtube: "Comedy"; dailymotion: "fun" }
        ListElement { name: QT_TR_NOOP("Education"); youtube: "Education"; dailymotion: "schools" }
        ListElement { name: QT_TR_NOOP("Entertainment"); youtube: "Entertainment"; dailymotion: "fun" }
        ListElement { name: QT_TR_NOOP("Film"); youtube: "Film"; dailymotion: "shortfilms" }
        ListElement { name: QT_TR_NOOP("Gaming"); youtube: "Games"; dailymotion: "videogames" }
        ListElement { name: QT_TR_NOOP("Most Recent"); youtube: "MostRecent"; dailymotion: "MostRecent" }
        ListElement { name: QT_TR_NOOP("Most Viewed"); youtube: "MostViewed"; dailymotion: "MostViewed" }
        ListElement { name: QT_TR_NOOP("Music"); youtube: "Music"; dailymotion: "music" }
        ListElement { name: QT_TR_NOOP("News & Politics"); youtube: "News"; dailymotion: "news" }
        ListElement { name: QT_TR_NOOP("Non-profits & Activism"); youtube: "Nonprofit"; dailymotion: "news" }
        ListElement { name: QT_TR_NOOP("People"); youtube: "People"; dailymotion: "people" }
        ListElement { name: QT_TR_NOOP("Pets & Animals"); youtube: "Animals"; dailymotion: "animals" }
        ListElement { name: QT_TR_NOOP("Science & Technology"); youtube: "Tech"; dailymotion: "tech" }
        ListElement { name: QT_TR_NOOP("Sport"); youtube: "Sports"; dailymotion: "sport" }
        ListElement { name: QT_TR_NOOP("Travel & Events"); youtube: "Travel"; dailymotion: "travel" }
    }
    selectedIndex: -1
    emitValueChosenSignal: false
    onAccepted: showCategoryVideos(model.get(selectedIndex))
}
