#ifndef UTILS_H
#define UTILS_H

#include <QObject>
#include <QProcess>
#include <QVariantList>

class QWidget;

#include "qmlapplicationviewer.h"

class Utils : public QObject {
    Q_OBJECT

    Q_PROPERTY(QString currentTime
               READ getCurrentTime
               NOTIFY currentTimeChanged)

public:
    explicit Utils(QObject *parent = 0);

    void setView(QmlApplicationViewer* view);
    QString getCurrentTime() const { return currentTime; }

public slots:

    QVariantList getInstalledMediaPlayers() const;
    bool widgetInstalled() const;
    bool xTubeInstalled() const;
    void setMediaPlayer(const QString &player);
    void doNotDisturb(bool preventDisturb);
    void toggleState();
    void minimize();
    void playVideo(const QString &url);
    bool pathExists(const QString &path);
    void copyToClipboard(const QString &url);
    QString getDocsDirectory() const;

private slots:
    void updateCurrentTime();

private:
    QmlApplicationViewer *viewer;
    QString mediaPlayer;
    QString currentTime;

signals:
    void alert(const QString &message);
    void currentTimeChanged();
};

#endif // UTILS_H
