import QtQuick 1.0
import "scripts/createobject.js" as ObjectCreator
import "scripts/youtube.js" as YT
import "scripts/videolistscripts.js" as Scripts

Page {
    id: root

    property string videoFeed
    property alias checkList: videoList.checkList

    function setVideoFeed(feed) {
        videoFeed = feed;
        YT.getYouTubeVideos(feed);
    }

    function goToRelatedVideo(video) {
        pageStack.push(Qt.resolvedUrl("YTInfoPage.qml"));
        pageStack.currentPage.setVideo(video);
    }

    function selectAll() {
        Scripts.selectAll()
    }

    function selectNone() {
        Scripts.selectNone();
    }

    function addVideosToFavourites() {
        YT.addVideosToFavourites();
    }

    function showPlaylistDialog() {
        YT.showPlaylistDialog();
    }

    function addVideosToWatchLaterPlaylist() {
        YT.addVideosToWatchLaterPlaylist();
    }

    function addVideosToPlaybackQueue() {
        YT.addVideosToPlaybackQueue();
    }

    function addVideosToDownloadQueue(convertToAudio) {
        YT.addVideosToDownloadQueue(convertToAudio);
    }

    title: qsTr("Related")
    tools: Menu {

        menuItems: [

            MenuItem {
                text: videoList.checkList.length === 0 ? qsTr("Select all") : qsTr("Select none")
                closeMenuWhenClicked: false
                onClicked: videoList.checkList.length === 0 ? selectAll() : selectNone()
            },

            MenuItem {
                text: qsTr("Add to favourites")
                visible: YouTube.userSignedIn
                enabled: videoList.checkList.length > 0
                onClicked: addVideosToFavourites()
            },

            MenuItem {
                text: qsTr("Add to playlist")
                visible: YouTube.userSignedIn
                enabled: videoList.checkList.length > 0
                onClicked: showPlaylistDialog()
            },

            MenuItem {
                text: qsTr("Watch later")
                visible: YouTube.userSignedIn
                enabled: videoList.checkList.length > 0
                onClicked: addVideosToWatchLaterPlaylist()
            },

            MenuItem {
                text: qsTr("Play")
                visible: Settings.mediaPlayer == "cutetubePlayer"
                enabled: videoList.checkList.length > 0
                onClicked: addVideosToPlaybackQueue()
            },

            MenuItem {
                text: qsTr("Download")
                enabled: videoList.checkList.length > 0
                onClicked: addVideosToDownloadQueue(false)
            },

            MenuItem {
                text: qsTr("Download (audio)")
                enabled: videoList.checkList.length > 0
                onClicked: addVideosToDownloadQueue(true)
            }
        ]
    }

    ListView {
        id: videoList

        property variant checkList: []

        anchors.fill: parent
        boundsBehavior: Flickable.DragOverBounds
        highlightRangeMode: ListView.StrictlyEnforceRange
        cacheBuffer: 2500
        clip: true
        onCurrentIndexChanged: {
            if ((videoList.currentIndex > 0) && (videoList.count - videoList.currentIndex == 1)
                    && (videoListModel.count < videoListModel.totalResults)
                    && (!videoListModel.loading)) {
                YT.getYouTubeVideos(videoFeed);
            }
        }

        footer: Item {
            id: footer

            width: videoList.width
            height: 100
            visible: videoListModel.loading
            opacity: footer.visible ? 1 : 0

            BusyDialog {
                anchors.centerIn: footer
                opacity: footer.opacity
            }
        }

        model: ListModel {
            id: videoListModel

            property bool loading: false
            property bool error: false
            property bool totalResults
            property int page: 0
        }

        delegate: YTListDelegate {
            id: delegate

            function addOrRemoveFromCheckList() {
                var cl = videoList.checkList;
                if (!delegate.checked) {
                    cl.push(index);
                }
                else {
                    for (var i = 0; i < cl.length; i++) {
                        if (cl[i] == index) {
                            cl.splice(i, 1);
                        }
                    }
                }
                videoList.checkList = cl;
            }

            checked: Scripts.indexInCheckList(index)
            onClicked: {
                if (videoList.checkList.length === 0) {
                    goToRelatedVideo(videoListModel.get(index));
                }
                else {
                    addOrRemoveFromCheckList();
                }
            }
            onPressAndHold: addOrRemoveFromCheckList()
            onPlayClicked: if (videoList.checkList.length === 0) playVideo(videoId)
        }

        ScrollBar {}
    }


    Text {
        id: noResultsText

        anchors.centerIn: videoList
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No related videos")
        visible: (!videoListModel.loading) && (videoListModel.count == 0)
    }
}
