import QtQuick 1.0
import "scripts/createobject.js" as ObjectCreator
import "scripts/youtube.js" as YT

Page {
    id: root

    property bool autoLoad: true
    property string playlistFeed

    function setPlaylistFeed(feed) {
        playlistFeed = feed;
        YT.getPlaylists(playlistFeed);
    }

    function goToPlaylistVideos(playlist) {
        pageStack.push(Qt.resolvedUrl("YTPlaylistVideosPage.qml"));
        pageStack.currentPage.setPlaylist(playlist);
    }

    title: qsTr("Playlists")

    Connections {
        target: playlistModel
        onLoadingChanged: {
            if ((autoLoad) && (!playlistModel.loading) && (!playlistModel.error) && (playlistModel.count < playlistModel.totalResults)) {
                YT.getPlaylists(playlistFeed);
            }
        }
    }

    ListView {
        id: playlists

        anchors { fill: parent; topMargin: pageStack.currentPage == root ? titleArea.height : 0 }
        boundsBehavior: Flickable.DragOverBounds
        highlightRangeMode: ListView.StrictlyEnforceRange
        clip: true
        onCurrentIndexChanged: {
            if ((!autoLoad) && (playlists.count - playlists.currentIndex == 1) && (!playlistModel.loading) && (playlistModel.count < playlistModel.totalResults)) {
                YT.getPlaylists(playlistFeed);
            }
        }
        model: ListModel {
            id: playlistModel

            property bool loading : false
            property int totalResults
            property bool error: false
            property int page : 0
        }
        delegate: YTPlaylistDelegate {
            id: delegate

            onClicked: goToPlaylistVideos(ObjectCreator.cloneObject(playlistModel.get(index)))
        }
        footer: Item {
            id: footer

            width: playlists.width
            height: 80
            visible: playlistModel.loading
            opacity: footer.visible ? 1 : 0

            BusyDialog {
                anchors.centerIn: footer
                opacity: footer.opacity
            }
        }

        ScrollBar {}
    }

    Text {
        anchors.centerIn: playlists
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No playlists found")
        visible: (!playlistModel.loading) && (playlistModel.count === 0)
    }
}
