import QtQuick 1.0

Item {
    id: root

    signal clicked

    width: root.ListView.view.width
    height: 80

    ListHighlight {
        visible: (mouseArea.pressed) || (root.ListView.view.currentIndex == index)
    }

    Text {
        id: titleText

        anchors { left: root.left; leftMargin: 10; right: root.right; rightMargin: 10; verticalCenter: root.verticalCenter }
        elide: Text.ElideRight
        text: name
        color: _TEXT_COLOR
        font.pixelSize: _STANDARD_FONT_SIZE
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    MouseArea {
        id: mouseArea

        anchors.fill: root
        onClicked: root.clicked()
    }
}
