import QtQuick 1.0

Item {
    id: delegate

    property alias videoTitle: titleText.text
    property alias checked : checkbox.visible

    signal clicked
    signal pressAndHold

    function getDuration(secs) {
        /* Converts seconds to HH:MM:SS format. */
        var hours = Math.floor(secs / 3600);
        var minutes = Math.floor(secs / 60) - (hours * 60);
        var seconds = secs - (hours * 3600) - ( minutes * 60);
        if (seconds < 10) {
            seconds = "0" + seconds;
        }
        var duration = minutes + ":" + seconds;
        if (hours > 0) {
            duration = hours + ":" + duration;
        }
        return duration;
    }

    width: delegate.ListView.view.width; height: 100
    smooth: true

    ListHighlight {
        visible: (mouseArea.pressed) || (delegate.ListView.view.parent.playlistPosition == index)
    }

    Text {
        id: titleText

        elide: Text.ElideRight
        text: title
        color: "white"
        font.pixelSize: _STANDARD_FONT_SIZE
        anchors { left: frame.right; leftMargin: 5; right: delegate.right; rightMargin: 5; top: frame.top }
        verticalAlignment: Text.AlignTop
        smooth: true
    }

    Image {
        id: frame

        z: 1
        width: 122
        height: 92
        anchors { left: delegate.left; verticalCenter: delegate.verticalCenter }
        source: "images/frame.png"
        sourceSize.width: width
        sourceSize.height: height
        smooth: true

        Image {
            id: thumb

            z: -1
            anchors.fill: frame
            source: thumbnail
            smooth: true
            onStatusChanged: {
                if (thumb.status == Image.Error) {
                    thumb.source = "images/error.jpg";
                }
            }
        }
    }

    Image {
        id: checkbox

        width: 70
        height: 70
        source: "images/tick.png"
        visible: false
        smooth: true
        anchors {
            verticalCenter: parent.verticalCenter
            right: parent.right
            rightMargin: 5
        }
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: parent.clicked()
        onPressAndHold: parent.pressAndHold()
    }
}
