import QtQuick 1.0
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    function showCategoryDialog() {
        var categoryDialog = ObjectCreator.createObject(Qt.resolvedUrl("CategoryDialog.qml"), appWindow);
        categoryDialog.open();
    }

    function showSearchDialog() {
        var searchDialog = ObjectCreator.createObject(Qt.resolvedUrl("SearchDialog.qml"), appWindow);
        searchDialog.open();
    }

    function showAboutDialog() {
        var aboutDialog = ObjectCreator.createObject(Qt.resolvedUrl("AboutDialog.qml"), appWindow);
        aboutDialog.open();
    }

    function showSettings() {
        pageStack.push(Qt.resolvedUrl("SettingsPage.qml"));
    }

    function showAccounts() {
        pageStack.push(Qt.resolvedUrl("AccountsPage.qml"));
    }

    function showArchive() {
        pageStack.push(Qt.resolvedUrl("ArchivePage.qml"));
    }

    function showSignInDialog() {
        var signInDialog = ObjectCreator.createObject(Qt.resolvedUrl("SignInDialog.qml"), appWindow);
        signInDialog.open();
    }

    function showYouTubeUserProfile() {
        pageStack.push(Qt.resolvedUrl("YTCurrentUserPage.qml"));
    }

    function showDailymotionUserProfile() {
        pageStack.push(Qt.resolvedUrl("DMCurrentUserPage.qml"));
    }

    function showTransfers() {
        transfers.transferHasFailed = false;
        pageStack.push(Qt.resolvedUrl("TransferListPage.qml"));
    }

    title: "cuteTube"
    tools: Menu {

        menuItems: [

            MenuItem {
                text: qsTr("Accounts")
                onClicked: showAccounts()
            },

            MenuItem {
                text: qsTr("Settings")
                onClicked: showSettings()
            },

            MenuItem {
                text: qsTr("About")
                onClicked: showAboutDialog()
            },

            MenuItem {
                text: qsTr("Transfers") + " (" + transfers.count.toString() + ")"
                textColor: transfers.transferHasFailed ? "red" : !transfers.transferInProgress ? "#4d4d4d" : _TEXT_COLOR
                onClicked: showTransfers()
            }
        ]
    }

    ContextMenu {
        id: accountsMenu

        titleText: qsTr("Choose site")
        menuItems: [
            ContextMenuItem {
                text: "YouTube"
                enabled: YouTube.userSignedIn
                onClicked: showYouTubeUserProfile()
            },

            ContextMenuItem {
                text: "Dailymotion"
                enabled: Dailymotion.userSignedIn
                onClicked: showDailymotionUserProfile()
            }
        ]
    }

    Grid {
        id: iconGrid

        anchors { fill: parent; topMargin: titleArea.height }
        columns: !appWindow.inPortrait ? 2 : 1
        rows: !appWindow.inPortrait ? 2 : 4

        NavButton {
            id: myAccountButton

            width: Math.floor(parent.width / parent.columns)
            height: Math.floor(parent.height / parent.rows)
            iconSource: Settings.appTheme == "light" ? "images/icon-m-content-avatar-placeholder.png" : "images/icon-m-telephony-avatar-placeholder.png"
            label: qsTr("My Channel")
            onClicked: (YouTube.userSignedIn) && (Dailymotion.userSignedIn) ? accountsMenu.open() : YouTube.userSignedIn ? showYouTubeUserProfile() : Dailymotion.userSignedIn ? showDailymotionUserProfile() : showSignInDialog()
        }

        NavButton {
            id: searchButton

            width: Math.floor(parent.width / parent.columns)
            height: Math.floor(parent.height / parent.rows)
            iconSource: Settings.appTheme == "light" ? "images/icon-m-content-search.png" : "images/icon-m-content-search-inverse.png"
            label: qsTr("Search")
            onClicked: showSearchDialog()
        }

        NavButton {
            id: catButton

            width: Math.floor(parent.width / parent.columns)
            height: Math.floor(parent.height / parent.rows)
            iconSource: Settings.appTheme == "light" ? "images/icon-m-content-file-unknown.png" : "images/icon-m-content-file-unknown-inverse.png"
            label: qsTr("Categories")
            onClicked: showCategoryDialog()
        }

        NavButton {
            id: archiveButton

            width: Math.floor(parent.width / parent.columns)
            height: Math.floor(parent.height / parent.rows)
            iconSource: Settings.appTheme == "light" ? "images/icon-m-download.png" : "images/icon-m-download-inverse.png"
            label: qsTr("Archive")
            onClicked: showArchive()
        }
    }
}
