import QtQuick 1.0

Item {
    id: delegate

    property string title

    signal clicked
    signal pressAndHold

    width: parent.width
    height: 80

    ListHighlight {
        visible: mouseArea.pressed
    }

    Text {
        anchors { fill: parent; leftMargin: 10 }
        font.bold: true
        color: _TEXT_COLOR
        font.pixelSize: _STANDARD_FONT_SIZE
        verticalAlignment: Text.AlignVCenter
        text: title
    }

    Image {
        anchors { right: parent.right; rightMargin: 20; verticalCenter: parent.verticalCenter }
        source: Settings.appTheme == "light" ? "images/drilldown-arrow.png" : "images/drilldown-arrow-white.png"
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: parent.clicked()
        onPressAndHold: parent.pressAndHold()
    }
}
