import QtQuick 1.0
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    function goToUserProfile(userId) {
        pageStack.push(Qt.resolvedUrl("DMUserPage.qml"));
        pageStack.currentPage.getUserProfile(userId);
    }

    function goToNewSubVideos() {
        pageStack.push(Qt.resolvedUrl("DMListPage.qml"));
        pageStack.currentPage.setVideoFeed(_DM_NEW_SUB_VIDEOS_FEED);
        pageStack.currentPage.title = qsTr("New Subscription Videos");
    }

    title: qsTr("My Subscriptions")
    tools: Menu {

        menuItems: MenuItem {
            text: qsTr("New subscription videos")
            onClicked: goToNewSubVideos()
        }
    }

    ListView {
        id: subscriptionsList

        anchors.fill: parent
        boundsBehavior: Flickable.DragOverBounds
        highlightRangeMode: ListView.StrictlyEnforceRange
        clip: true
        model: dailymotionSubscriptionsModel
        delegate: DMSubscriptionDelegate {
            id: delegate

            onClicked: goToUserProfile(id)
        }
        footer: Item {
            id: footer

            width: subscriptionsList.width
            height: 80
            visible: dailymotionSubscriptionsModel.loading
            opacity: footer.visible ? 1 : 0

            BusyDialog {
                anchors.centerIn: footer
                opacity: footer.opacity
            }
        }

        ScrollBar {}
    }

    Text {
        anchors.centerIn: subscriptionsList
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No subscriptions found")
        visible: (!dailymotionSubscriptionsModel.loading) && (dailymotionSubscriptionsModel.count === 0)
    }
}
