import QtQuick 1.0
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    property Item infoPage: null
    property Item commentsPage: null
    property Item relatedPage: null

    function setVideo(videoObject) {
        infoPage = tabGroup.addTab(Qt.resolvedUrl("DMDescriptionPage.qml"), 0);
        infoPage.setVideo(videoObject);
    }

    function showPlaylistDialog() {
        var playlistDialog = ObjectCreator.createObject(Qt.resolvedUrl("DMPlaylistDialog.qml"), appWindow);
        playlistDialog.playlistChosen.connect(addVideoToPlaylist);
        playlistDialog.open();
    }

    function addVideoToPlaylist(playlistId) {
        toggleBusy(true);
        Dailymotion.addToPlaylist(infoPage.video.id, playlistId);
    }

    function showEditMetadataDialog() {
        var editDialog = ObjectCreator.createObject(Qt.resolvedUrl("DMEditMetadataDialog.qml"), appWindow);
        editDialog.getVideoMetadata(infoPage.video.videoId);
        editDialog.metadataUpdated.connect(updateMetadata);
        editDialog.open();
    }

    function updateMetadata(metadata) {
        var video = infoPage.video;
        video["title"] = metadata.title;
        video["description"] = metadata.description;
        video["tags"] = metadata.tags;
        infoPage.video = video;
    }

    function showCommentDialog() {
        var commentDialog = ObjectCreator.createObject(Qt.resolvedUrl("AddCommentDialog.qml"), appWindow);
        commentDialog.videoId = infoPage.video.id;
        commentDialog.open();
    }

    function loadComments() {
        commentsPage = tabGroup.addTab(Qt.resolvedUrl("DMCommentsPage.qml"), 1);
        commentsPage.setCommentsFeed(infoPage.video.videoId);
    }

    function loadRelated() {
        relatedPage = tabGroup.addTab(Qt.resolvedUrl("DMRelatedVideosPage.qml"), 2);
        relatedPage.setVideoFeed("https://api.dailymotion.com/video/" + infoPage.video.id + "/related?limit=30&family_filter=" + Settings.safeSearch.toString() + "&fields=" + _DM_VIDEO_FIELDS);
    }

    title: tabGroup.currentTab === null ? "" : tabGroup.currentTab.title
    tools: tabGroup.currentTab === null ? null : tabGroup.currentTab.tools

    TabGroup {
        id: tabGroup

        anchors { fill: parent; topMargin: titleArea.height + tabBar.height }
    }

    TabBar {
        id: tabBar

        anchors { left: parent.left; right: parent.right; top: parent.top; topMargin: titleArea.height }

        buttons: [
            TabButton {
                text: qsTr("Info")
                checked: tabGroup.currentTab == infoPage
                onClicked: tabGroup.setTab(0)
            },

            TabButton {
                text: (infoPage === null) || (!infoPage.video.comments_total) ? qsTr("Comments") : qsTr("Comments") + " (" + infoPage.video.comments_total.toString() + ")"
                checked: tabGroup.currentTab == commentsPage
                onClicked: if (commentsPage === null) loadComments(); else tabGroup.setTab(1);
            },

            TabButton {
                text: qsTr("Related")
                checked: tabGroup.currentTab == relatedPage
                onClicked: if (relatedPage === null) loadRelated(); else tabGroup.setTab(2);
            }
        ]
    }
}

