import QtQuick 1.0
import "scripts/dailymotion.js" as DM
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    property string videoId
    property alias commentCount: commentsModel.count

    function setCommentsFeed(id) {
        videoId = id;
        DM.getComments(id);
    }

    function goToUserProfile(userId) {
        pageStack.push(Qt.resolvedUrl("DMUserPage.qml"));
        pageStack.currentPage.getUserProfile(userId);
    }

    function showCommentDialog() {
        var commentDialog = ObjectCreator.createObject(Qt.resolvedUrl("AddCommentDialog.qml"), appWindow);
        commentDialog.site = "dailymotion";
        commentDialog.videoId = videoId;
        commentDialog.open();
    }

    title: qsTr("Comments")
    tools: Menu {

        menuItems: MenuItem {
            text: qsTr("Add comment")
            enabled: Dailymotion.userSignedIn
            onClicked: showCommentDialog()
        }
    }

    ListView {
        id: commentsList

        anchors.fill: parent
        clip: true
        highlightRangeMode: ListView.StrictlyEnforceRange

        footer: Item {
            id: footer

            width: commentsList.width
            height: 100
            visible: commentsModel.loading

            BusyDialog {
                anchors.centerIn: footer
                visible: footer.visible
            }
        }

        model: ListModel {
            id: commentsModel

            property bool loading: false
            property bool moreResults: false
            property int page: 1
            property bool error: false

            function reset() {
                commentsModel.clear();
                commentsModel.moreResults = false;
                commentsModel.page = 1;
                DM.getComments(videoId);
            }
        }

        onCurrentIndexChanged: {
            if ((commentsList.currentIndex > 0) && (commentsList.count - commentsList.currentIndex == 1)
                    && (commentsModel.moreResults)
                    && (!commentsModel.loading)) {
                DM.getComments(videoId);
            }
        }

        delegate: DMCommentsDelegate {
            id: commentDelegate

            onCommentClicked: goToUserProfile(userId)
        }

        ScrollBar {}
    }

    Text {
        id: noResultsText

        anchors.centerIn: commentsList
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No comments")
        visible: (!commentsModel.loading) && (commentsModel.count == 0)
    }
}
