import QtQuick 1.0
import QtMobility.systeminfo 1.2

Item {
    id: root

    width: 15
    height: 35

    Rectangle {
        id: top

        width: 7
        anchors { bottom: border.top; top: parent.top; horizontalCenter: parent.horizontalCenter }
        color: _TEXT_COLOR
    }

    Rectangle {
        id: border

        anchors { fill: parent; topMargin: 5 }
        color: "transparent"
        border.color: _TEXT_COLOR
        border.width: 2
    }

    Rectangle {
        height: Math.floor((border.height - 4) * batteryInfo.remainingCapacityPercent / 100)
        anchors { left: border.left; right: border.right; bottom: border.bottom; margins: 2 }
        color: batteryInfo.remainingCapacityPercent < 10 ? "red" : "green"
    }

    BatteryInfo {
        id: batteryInfo

        monitorRemainingCapacityPercentChanges: true
    }
}
