import QtQuick 1.0

QueryDialog {
    id: root

    property string site: "youtube"
    property string videoId

    function addComment() {
        toggleBusy(true);
        if (site == "youtube") {
            YouTube.addComment(videoId, commentInput.text);
        }
        else {
            Dailymotion.addComment(videoId, commentInput.text);
        }
    }

    titleText: qsTr("Add comment")
    acceptButtonText: (commentInput.text == "") ? "" : qsTr("Done")
    rejectButtonText: qsTr("Cancel")
    onAccepted: addComment()
    content: Item {
        anchors.fill: parent

        Flickable {
            id: flicker

            anchors { fill: parent; margins: 10 }
            contentWidth: width
            contentHeight: col1.height + 20
            flickableDirection: Flickable.VerticalFlick
            clip: true

            Column {
                id: col1

                anchors { left: parent.left; right: parent.right; top: parent.top }
                spacing: 10

                TextArea {
                    id: commentInput

                    width: parent.width
                }
            }
        }
    }

    MouseArea {
        z: -1
        anchors.fill: parent
    }
}
