import QtQuick 1.0
import "scripts/createobject.js" as ObjectCreator
import "scripts/settings.js" as Settings

FocusScope {
    id: dialog

    property alias searchText : searchInput.text
    property string searchOrder
    property string site : "YouTube"

    signal close
    signal search(string query, string order, string site)
    signal ytVideo(variant video)
    signal dmVideo(variant video)
    signal vimeoVideo(variant video)

    function getYouTubeVideo(id) {
        var request = new XMLHttpRequest();
        request.onreadystatechange = function() {
            if (request.readyState == XMLHttpRequest.DONE) {
                console.log(request.responseText)
                var res = eval("(" + request.responseText + ")").entry;
                if ((res.app$control) && (res.app$control.yt$state) && (res.app$control.yt$state.reasonCode != "limitedSyndication")) {
                    messages.displayMessage(qsTr("Video is not available"));
                }
                else {
                    ytVideo({ "playerUrl": "http://youtube.com/watch?v=" + res.media$group.yt$videoid.$t, "id": res.id.$t,
                            "videoId": res.media$group.yt$videoid.$t, "title": res.title.$t,
                            "description": res.media$group.media$description.$t, "author": res.media$group.media$credit[0].$t,
                            "likes": res.yt$rating ? res.yt$rating.numLikes : "0", "dislikes": res.yt$rating ? res.yt$rating.numDislikes : "0",
                                                                                                                                         "views": res.yt$statistics ? res.yt$statistics.viewCount : "0", "duration": res.media$group.yt$duration.seconds,
                                                                                                                                                                                                  "tags": res.media$group.media$keywords.$t, "uploadDate": res.media$group.yt$uploaded.$t,
                                                                                                                                                                                                  "thumbnail": res.media$group.media$thumbnail[0].url, "comments": res.gd$comments ? res.gd$comments.gd$feedLink.countHint : "0",
                                                                                                                                                                                                                                                                                                                           "largeThumbnail": res.media$group.media$thumbnail[1].url, "youtube": true });
                }
                close();
            }
        }
        request.open("GET", "http://gdata.youtube.com/feeds/api/videos/" + id + "?v=2&alt=json");
        request.send();
    }

    function getDailymotionVideo(id) {
        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                var res = eval("(" + doc.responseText + ")");

                dmVideo({ "playerUrl": "http://iphone.dailymotion.com/video/" + res.id, "id": res.id, "title": res.title,
                        "description": res.description, "author": res.owner, "rating": res.rating,
                        "views": res.views_total, "duration": res.duration, "tags": res.tags.toString(),
                        "thumbnail": res.thumbnail_medium_url,
                        "largeThumbnail": res.thumbnail_large_url, "dailymotion": true });
                close();
            }
        }
        doc.open("GET", "https://api.dailymotion.com/video/" + id + "&fields=" + _DM_FIELDS);
        doc.send();
    }

    function getVimeoVideo(id) {
        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                var res = eval("(" + doc.responseText + ")").video[0];
                //                            console.log(doc.responseText)

                var tags = "";
                for (var i = 0; i < res.tags.tag.length; i++) {
                    tags += res.tags.tag[i]._content + ", ";
                }
                vimeoVideo({ "playerUrl": res.urls.url[0]._content,
                           "id": res.id, "title": res.title,
                           "description": res.description, "author": res.owner.display_name,
                           "authorId": res.owner.id, "uploadDate": res.upload_date, "likes": res.number_of_likes,
                           "views": res.number_of_plays, "comments": res.number_of_comments,
                           "duration": res.duration, "tags": tags, "thumbnail": res.thumbnails.thumbnail[1]._content,
                           "largeThumbnail": res.thumbnails.thumbnail[2]._content, "vimeo": true });

                if (res.urls.url.length < 2) {
                    messages.displayMessage(qsTr("This video cannot be played or downloaded"));
                }
                close();
            }
        }
        var params = [["format", "json"], ["method", "vimeo.videos.getInfo"], ["video_id", id]];
        var oauthData = OAuth.createOAuthHeader("vimeo", "GET", "http://vimeo.com/api/rest/v2/", undefined, undefined, params);
        doc.open("GET", oauthData.url);
        doc.setRequestHeader("Authorization", oauthData.header);
        doc.send();
    }

    function parseSearchQuery() {
        if (searchInput.text.length > 0) {
            var query = searchInput.text;
            var youtube = /youtu.be|youtube.com/; // Check if user entered a direct link to a video
            var dailymotion = /dailymotion.com\/video/;
            var vimeo = /vimeo.com/;
            var videoId;
            if (youtube.test(query)) {
                videoId = query.split("v=")[1].split("&")[0]; // Extract videoId from link
                getYouTubeVideo(videoId);
            }
            else if (dailymotion.test(query)) {
                videoId = query.split("/").pop().split("_")[0];
                getDailymotionVideo(videoId);
            }
            else if (vimeo.test(query)) {
                videoId = query.split("/").pop().split("_")[0];
                getVimeoVideo(videoId);
            }
            else {
                search(query, dialog.searchOrder, dialog.site);
                Settings.setSetting("searchOrder", dialog.searchOrder);
                Settings.setSetting("searchSite", dialog.site);
                Settings.addSearchTerm(query);
                close();
            }
        }
    }

    function getSearches() {
        /* Retreive the searches from the database and
          populate the model */

        searchOrder = Settings.getSetting("searchOrder");
        site = Settings.getSetting("searchSite");
        var searches = Settings.getSearches();
        for (var i = 0; i < searches.length; i++) {
            searchModel.insert(0, { "searchterm": searches[i] });
        }
    }

    function changeSearchOrder() {
        if (dialog.searchOrder == "published") {
            dialog.searchOrder = "relevance";
        }
        else if (dialog.searchOrder == "relevance") {
            dialog.searchOrder = "viewCount";
        }
        else if (dialog.searchOrder == "viewCount") {
            dialog.searchOrder = "rating";
        }
        else if (dialog.searchOrder == "rating") {
            dialog.searchOrder = "published";
        }
    }

    focus: true
    width: parent.width
    anchors { right: parent.left; top: parent.top; bottom: parent.bottom }

    Component.onCompleted: getSearches()

    Connections {
        target: dialog.parent

        onDialogClose: {
            dialog.state = "";
            dialog.destroy(600);
        }
    }

    Rectangle {
        id: background

        anchors.fill: dialog
        color: _BACKGROUND_COLOR
        opacity: 0.5
    }

    Text {
        id: title

        anchors { top: parent.top; topMargin: 10; horizontalCenter: parent.horizontalCenter }
        color: _TEXT_COLOR
        font.pixelSize: _SMALL_FONT_SIZE
        text: qsTr("Search")
    }

    Column {
        id: column

        spacing: 10
        anchors { top: parent.top; topMargin: 80; left: parent.left; leftMargin: 10; right: (dialog.width > dialog.height) && (searchList.count > 0) ? parent.horizontalCenter : parent.right; rightMargin: 10 }

        LineEdit {
            id: searchInput

            width: parent.width
            inputFocus: true
            buttonMargin: 50
            Keys.onEnterPressed: parseSearchQuery()
            Keys.onReturnPressed: parseSearchQuery()

            Image {
                width: 40
                height: 40
                anchors { right: parent.right; rightMargin: 5; verticalCenter: parent.verticalCenter }
                source: mouseArea.pressed ? "ui-images/searchicon.png" : "ui-images/searchiconlight.png"
                sourceSize.width: width
                sourceSize.height:height

                MouseArea {
                    id: mouseArea

                    anchors.fill: parent
                    onClicked: parseSearchQuery()
                }
            }
        }

        Text {
            color: "grey"
            font.pixelSize: _SMALL_FONT_SIZE
            text: qsTr("Site")
        }

        SplitButton {
            id: siteButtons

            property variant sites : ["YouTube", "Dailymotion", "vimeo"]

            width: parent.width
            buttonCount: 3
            Component.onCompleted: {
                setButtons(siteButtons.sites);
                var found = false;
                var i = 0;
                var savedSite = Settings.getSetting("searchSite");
                while ((!found) && (i < sites.length)) {
                    if (sites[i] == savedSite) {
                        currentButton = i;
                        found = true;
                    }
                    i++;
                }
            }
            onCurrentButtonChanged: site = sites[currentButton]
        }

        Text {
            color: "grey"
            font.pixelSize: _SMALL_FONT_SIZE
            text: qsTr("Order")
        }

        SplitButton {
            id: orderButtons

            property variant orderNames : [qsTr("Date"), qsTr("Relevance"), qsTr("Views"), qsTr("Rating")]
            property variant searchOrders : ["published", "relevance", "viewCount", "rating"]

            width: parent.width
            buttonCount: 4
            Component.onCompleted: {
                setButtons(orderButtons.orderNames);
                var found = false;
                var i = 0;
                var savedOrder = Settings.getSetting("searchOrder");
                while ((!found) && (i < searchOrders.length)) {
                    if (searchOrders[i] == savedOrder) {
                        currentButton = i;
                        found = true;
                    }
                    i++;
                }
            }
            onCurrentButtonChanged: searchOrder = orderButtons.searchOrders[currentButton]
        }
    }

    ListView {
        id: searchList

        anchors { left: (dialog.width > dialog.height) && (searchList.count > 0) ? parent.horizontalCenter : parent.left; leftMargin: 10;
            right: parent.right; rightMargin: 10;
            top: (dialog.width > dialog.height) && (searchList.count > 0) ? column.top : column.bottom; topMargin: (dialog.width > dialog.height) && (searchList.count > 0) ? 0 : 10
            bottom: parent.bottom; bottomMargin: 10 }
        boundsBehavior: Flickable.DragOverBounds
        model: ListModel {
            id: searchModel
        }
        clip: true
        delegate: Item {
            id: delegate

            width: delegate.ListView.view.width
            height: 60

            ListHighlight {
                visible: delMouseArea.pressed
            }

            Text {
                anchors { fill: delegate; leftMargin: 10 }
                font.pixelSize: _STANDARD_FONT_SIZE
                color: _TEXT_COLOR
                verticalAlignment: Text.AlignVCenter
                text: searchterm
            }

            MouseArea {
                id: delMouseArea

                anchors.fill: delegate
                onClicked: searchInput.text = searchterm
            }
        }

        ScrollBar {
        }
    }

    Rectangle {
        id: separator

        width: 1
        anchors { top: parent.top; topMargin: 70; bottom: parent.bottom; bottomMargin: 20; horizontalCenter: parent.horizontalCenter }
        color: _ACTIVE_COLOR_HIGH
        opacity: 0.5
        visible: (dialog.width > dialog.height) && (searchList.count > 0)
    }

    CloseButton {
        onButtonClicked: close()
    }

    MouseArea {

        property real xPos

        z: -1
        anchors.fill: dialog
        onPressed: xPos = mouseX
        onReleased: {
            if (xPos - mouseX > 100) {
                close();
            }
        }
    }

    states: State {
        name: "show"
        AnchorChanges { target: dialog; anchors.right: parent.right }
    }

    transitions: Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
    }
}
