import QtQuick 1.0

Item {
    id: delegate

    signal delegateClicked
    signal delegatePressed

    width: parent.width
    height: 100

    ListHighlight {
        visible: mouseArea.pressed
    }

    Text {
        id: titleText

        elide: Text.ElideRight
        text: title
        color: _TEXT_COLOR
        font.pixelSize: _STANDARD_FONT_SIZE
        anchors.fill: parent
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    Image {
        width: 40
        height: 40
        anchors { right: parent.right; rightMargin: 10; verticalCenter: parent.verticalCenter }
        source: (cuteTubeTheme == "nightred") ? "ui-images/countbubblered.png" : "ui-images/countbubbleblue.png"
        sourceSize.width: width
        sourceSize.height: height
        smooth: true

        Text {
            text: videoCount
            color: "white"
            font.pixelSize: _SMALL_FONT_SIZE
            anchors.fill: parent
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
        }
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: delegateClicked()
        onPressAndHold: delegatePressed()
    }
}
