import Qt 4.7

Item {

    id: button

    width: parent.width / 6
    height: parent.height

    property alias icon : icon.source

    signal buttonClicked
    signal buttonPressed

    Image {
        id: background

        width: 50
        height: 50
        anchors.centerIn: button
        source: (cuteTubeTheme == "nightred") ? "ui-images/menubuttonbackgroundred.png" : "ui-images/menubuttonbackground.png"
        sourceSize.width: background.width
        sourceSize.height: background.height
        smooth: true
        visible: mouseArea.pressed
    }

    Image {
        id: icon

        width: 50
        height: 50
        anchors.centerIn: button
        sourceSize.width: icon.width
        sourceSize.height: icon.height
        smooth: true
        opacity: 0.5
    }

    MouseArea {
        id: mouseArea

        anchors.fill: button
        onClicked: buttonClicked()
        onPressAndHold: buttonPressed()
    }
}




