import Qt 4.7

Item {
    id: menu

    property string currentSource : (menu.parent.currentIndex == 0) ? "HomeView" : menu.parent.currentItem.source

    property variant buttonOneIcons
    property variant buttonTwoIcons
    property variant buttonThreeIcons
    property variant buttonFourIcons
    property variant buttonFiveIcons

    signal backClicked
    signal homeClicked
    signal quitClicked

    width: parent.width
    height: 60
    anchors.bottom: parent.bottom
    z: 3

    Component.onCompleted: {
        buttonOneIcons = {
                "HomeView": "settingsicon", "MyAccountView": "uploadsicon", "VideoListView": "tick",
                "UserVideosView": "tick", "PlaylistVideosView": "tick",
                "PlaylistsView": "playlistsicon", "SubscriptionsView": "subscriptionsicon",
                "ArchiveListView": "tick", "VideoInfoView": "favouritesicon"
    };

        buttonTwoIcons = {
                "HomeView": "accountsicon", "MyAccountView": "inboxicon", "VideoListView": "favouritesicon",
                "UserVideosView": "favouritesicon", "PlaylistVideosView": "favouritesicon",
                "ArchiveListView": "deletearchiveicon", "VideoInfoView": "playlistsicon"
    };

        buttonThreeIcons = {
                "HomeView": "abouticon", "VideoListView": "playlistsicon",
                "UserVideosView": "playlistsicon", "PlaylistVideosView": "deleteplaylistsicon",
                "ArchiveListView": "deletediskicon", "VideoInfoView": "facebookicon"
    };

        buttonFourIcons = {
                "VideoListView": "videodownloadicon",
                "UserVideosView": "videodownloadicon", "PlaylistVideosView": "videodownloadicon",
                "ArchiveListView": "mostrecenticon", "VideoInfoView": "clipboardicon"
    };

        buttonFiveIcons = {
                "VideoListView": "audiodownloadicon",
                "UserVideosView": "audiodownloadicon", "PlaylistVideosView": "audiodownloadicon",
                "ArchiveListView": "sorttitleicon"
    };

    }

    Image {
        id: menuImage

        anchors.fill: menu
        source: "ui-images/menu2.png"
        sourceSize.width: menuImage.width
        sourceSize.height: menuImage.height
        fillMode: Image.PreserveAspectCrop
        smooth: true
        visible: !(cuteTubeTheme == "night")
    }

    Rectangle {
        id: background

        width: menu.width + 8
        height: menu.height + 8
        anchors.centerIn: menu
        radius: 10
        gradient: Gradient {
            GradientStop { id: gradient1; position: 0.0; color: _GRADIENT_COLOR_HIGH }
            GradientStop { id: gradient2; position: 0.7; color: _GRADIENT_COLOR_LOW }
        }
        border.width: 2
        border.color: _ACTIVE_COLOR_LOW
        opacity: 0.8
        smooth: true
        visible: (cuteTubeTheme == "night")
    }

    Row {
        anchors.fill: menu

        MenuButton {
            id: buttonOne

            showSeparator: false
            visible: menu.buttonOneIcons[menu.currentSource.split("/").pop().split(".")[0]] != undefined
            icon: {
                if (buttonOne.visible) {
                    if ((menu.parent.currentIndex > 0) && (menu.parent.currentItem.item.checkList) && (menu.parent.currentItem.item.checkList.length > 0)) {
                        "ui-images/ticknone.png";
                    }
                    else {
                        "ui-images/" + menu.buttonOneIcons[menu.currentSource.split("/").pop().split(".")[0]] + ".png";
                    }
                }
                else {
                    "";
                }
            }
            onButtonClicked: (menu.parent.currentIndex == 0) ? menu.parent.currentItem.onMenuButtonOneClicked() : menu.parent.currentItem.item.onMenuButtonOneClicked()
        }

        MenuButton {
            id: buttonTwo

            visible: menu.buttonTwoIcons[menu.currentSource.split("/").pop().split(".")[0]] != undefined
            icon: {
                if (buttonTwo.visible) {
                    if ((menu.parent.currentIndex > 0) && (menu.parent.currentItem.item.videoFeed == _FAVOURITES_FEED)) {
                        "ui-images/deletefavouritesicon.png";
                    }
                    else {
                        "ui-images/" + menu.buttonTwoIcons[menu.currentSource.split("/").pop().split(".")[0]] + ".png";
                    }
                }
                else {
                    "";
                }
            }
            onButtonClicked: (menu.parent.currentIndex == 0) ? menu.parent.currentItem.onMenuButtonTwoClicked() : menu.parent.currentItem.item.onMenuButtonTwoClicked()
        }

        MenuButton {
            id: buttonThree

            visible: menu.buttonThreeIcons[menu.currentSource.split("/").pop().split(".")[0]] != undefined
            icon: buttonThree.visible ? "ui-images/" + menu.buttonThreeIcons[menu.currentSource.split("/").pop().split(".")[0]] + ".png" : ""
            onButtonClicked: (menu.parent.currentIndex == 0) ? menu.parent.currentItem.onMenuButtonThreeClicked() : menu.parent.currentItem.item.onMenuButtonThreeClicked()
        }

        MenuButton {
            id: buttonFour

            visible: menu.buttonFourIcons[menu.currentSource.split("/").pop().split(".")[0]] != undefined
            icon: buttonFour.visible ? "ui-images/" + menu.buttonFourIcons[menu.currentSource.split("/").pop().split(".")[0]] + ".png" : ""
            onButtonClicked: menu.parent.currentItem.item.onMenuButtonFourClicked()

            Text {
                anchors { top: buttonFour.top; horizontalCenter: buttonFour.right }
                font.pixelSize: 14
                horizontalAlignment: Text.AlignHCenter
                color: "white"
                text: qsTr("Sort")
                smooth: true
                opacity: (menu.currentSource.split("/").pop().split(".")[0] == "ArchiveListView") ? 0.5 : 0
            }
        }

        MenuButton {
            id: buttonFive

            visible: menu.buttonFiveIcons[menu.currentSource.split("/").pop().split(".")[0]] != undefined
            icon: buttonFive.visible ? "ui-images/" + menu.buttonFiveIcons[menu.currentSource.split("/").pop().split(".")[0]] + ".png" : ""
            onButtonClicked: menu.parent.currentItem.item.onMenuButtonFiveClicked()
        }
    }

    MenuButton {
        id: backButton

        anchors.right: menu.right
        icon: "ui-images/backicon.png"
        onButtonClicked: backClicked()
        onButtonPressed: homeClicked()
        visible: !quitButton.visible
    }

    MenuButton {
        id: quitButton

        anchors.right: menu.right
        icon: "ui-images/quiticon.png"
        visible: menu.parent.currentIndex == 0
        onButtonClicked: quitClicked()
    }

    MouseArea {
        z: -1
        anchors.fill: menu
    }
}


