import Qt 4.7

Item {
    id: notificationArea

    property alias viewTitle: title.titleText
    property alias isBusy: busyIndicator.isBusy

    signal startSearch(string query, string order)
    signal goToVideo(variant video)
    signal goToDownloads

    function showSearchBar() {
        if (searchBar.source == "") {
            searchBar.source = "SearchBar.qml";
        }
    }

    function closeSearchBar() {
        searchBar.state = "";
        timer.running = true;
    }

    function sortNumber(a, b) {
        /* Sort function for the checkList */

        return b - a;
    }

    height: parent.height
    width: parent.width
    anchors { bottom: parent.top; bottomMargin: -50 }
    z: 100 // Ensures that the notification area is always on top

    Rectangle {
        id: background

        anchors { fill: notificationArea; bottomMargin: 50 }
        color: _BACKGROUND_COLOR
        opacity: 0.8
    }

    Text {
        anchors.centerIn: notificationArea
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "grey"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No active downloads")
        visible: (downloadsLoader.source != "") && (downloadsLoader.item.count == 0)
    }

    Loader {
        id: downloadsLoader

        anchors { left: notificationArea.left; right: notificationArea.right; bottom: notificationArea.bottom; bottomMargin: 50 }

        Timer {
            id: downloadsTimer

            interval: 600
            onTriggered: downloadsLoader.source = ""
        }
    }

    Rectangle {
        id: bar

        height: 50
        anchors { left: notificationArea.left; right: notificationArea.right; bottom: notificationArea.bottom }
        color: _BACKGROUND_COLOR
        opacity: notificationArea.state == "show" ? 1 : 0.5
        smooth: true
    }

    ToolButton {
        id: minimizeButton

        anchors { verticalCenter: bar.verticalCenter; left: bar.left; leftMargin: 10 }
        icon: (cuteTubeTheme == "light") ? "ui-images/minimizeiconlight.png" : "ui-images/minimizeicon.png"

        Connections {
            onButtonClicked: Controller.minimize()
            onButtonHeld: Controller.toggleState()
        }

    }

    Loader {
        id: searchBar

        anchors { left: bar.left; right: searchButton.left; bottom: bar.top; margins: 10 }
        z: 11
        focus: true
        visible: notificationArea.state == ""

        onLoaded: {
            searchBar.item.state = searchBar.state;
            searchBar.state = "show";
        }

        Timer {
            id: timer

            interval: 600
            onTriggered: searchBar.source = ""
        }

        Connections {
            target: searchBar.item

            onSearch: {
                startSearch(query, order);
                closeSearchBar();
            }
            onVideo: {
                goToVideo(video);
                closeSearchBar();
            }
        }

        states: State {
            name: "show"
            AnchorChanges { target: searchBar; anchors { bottom: undefined; top: bar.top } }
            PropertyChanges { target: searchBar; anchors.topMargin: 5 }
        }

        transitions: Transition {
            AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
        }
    }

    Text {
        id: title

        property string titleText

        anchors { fill: bar; leftMargin: 60; rightMargin: 150 }
        font.pixelSize: _STANDARD_FONT_SIZE
        color: _TEXT_COLOR
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignVCenter
        smooth: true
        text: notificationArea.state == "show" ? qsTr("Downloads") : qsTr(titleText)
    }

    Row {
        id: buttonRow

        anchors.centerIn: bar
        spacing: 10
        opacity: (notificationArea.state == "show") && (downloadsLoader.item.checkList.length > 0) ? 1 : 0

        Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 300 } }

        ToolButton {
            id: resumeButton

            icon: (cuteTubeTheme == "light") ? "ui-images/downloadiconlight.png" : "ui-images/downloadicon.png"

            onButtonClicked: {
                for (var i = 0; i < downloadsLoader.item.checkList.length; i++) {
                    downloadModel.resumeDownload(downloadsLoader.item.checkList[i]);
                }
                downloadsLoader.item.checkList = [];
                downloadModel.getNextDownload();
            }
        }

        ToolButton {
            id: pauseButton

            icon: (cuteTubeTheme == "light") ? "ui-images/pauseiconlight.png" : "ui-images/pauseicon.png"

            onButtonClicked: {
                for (var i = 0; i < downloadsLoader.item.checkList.length; i++) {
                    downloadModel.pauseDownload(downloadsLoader.item.checkList[i]);
                }
                downloadsLoader.item.checkList = [];
                downloadModel.getNextDownload();
            }
        }

        ToolButton {
            id: cancelButton

            icon: (cuteTubeTheme == "light") ? "ui-images/deleteiconlight.png" : "ui-images/deleteicon.png"

            onButtonClicked: {
                var list = downloadsLoader.item.checkList;
                list.sort(sortNumber);
                for (var i = 0; i < list.length; i++) {
                    downloadModel.cancelDownload(list[i]);
                }
                downloadsLoader.item.checkList = [];
                downloadModel.getNextDownload();
            }
        }
    }

    Image {
        id: busyIndicator

        property bool isBusy : false

        width: 40
        height: 40
        anchors { right: bar.right; rightMargin: downloadIndicator.visible ? 110 : 60; verticalCenter: bar.verticalCenter }
        source: "ui-images/busy.png"
        sourceSize.width: busyIndicator.width
        sourceSize.height: busyIndicator.height
        smooth: true
        opacity: 0

        NumberAnimation on rotation {
            running: busyIndicator.opacity > 0; from: 0; to: 360; loops: Animation.Infinite; duration: 1000
        }

        states: State {
            name: "busy"
            when: busyIndicator.isBusy
            PropertyChanges { target: busyIndicator; opacity: 1 }
        }

        transitions: Transition {
            PropertyAnimation { properties: "opacity"; duration: 500 }
        }
    }

    ToolButton {
        id: searchButton

        anchors { verticalCenter: bar.verticalCenter; right: bar.right; rightMargin: 10 }
        icon: (cuteTubeTheme == "light") ? "ui-images/searchiconlight.png" : "ui-images/searchicon.png"
        visible: notificationArea.state == ""

        Connections {
            onButtonClicked: {
                if (searchBar.source == "") {
                    showSearchBar();
                }
                else if (searchBar.item.searchText == "") {
                    closeSearchBar();
                }
                else {
                    searchBar.item.parseSearchQuery();
                }
            }
        }

    }

    Image {
        id: downloadIndicator

        anchors { bottom: bar.bottom; bottomMargin: 5; right: bar.right; rightMargin: 60 }
        width: 40
        height: 40
        source: (cuteTubeTheme == "light") ? "ui-images/downloadiconlight.png" : "ui-images/downloadicon.png"
        sourceSize.width: downloadIndicator.width
        sourceSize.height: downloadIndicator.height
        smooth: true
        clip: true
        visible: DownloadManager.isDownloading

        SequentialAnimation {
            running: DownloadManager.isDownloading
            loops: Animation.Infinite
            NumberAnimation { target: downloadIndicator; property: "opacity"; from: 0; to: 1; duration: 1500 }
            NumberAnimation { target: downloadIndicator; property: "opacity"; from: 1; to: 0; duration: 1500 }
        }
    }

    Rectangle {
        height: 1
        anchors { left: bar.left; leftMargin: 10; right: bar.right; rightMargin: 10; bottom: bar.top }
        color: _ACTIVE_COLOR_HIGH
        opacity: 0.5
    }

    Rectangle {
        height: 1
        anchors { left: bar.left; leftMargin: 10; right: bar.right; rightMargin: 10; bottom: bar.bottom }
        color: _ACTIVE_COLOR_HIGH
        opacity: 0.5
    }

    MouseArea {

        property real yPos
        anchors.fill: notificationArea
        z: -1
        onPressed: yPos = mouseY
        onReleased: {
            if (notificationArea.state == "") {
                if (mouseY - yPos > 30) {
                    downloadsLoader.source = "DownloadList.qml";
                    notificationArea.state = "show";
                }
            }
            else if (yPos - mouseY > 30) {
                notificationArea.state = "";
                downloadsTimer.running = true;
            }
        }
    }

    states: State {
        name: "show"
        AnchorChanges { target: notificationArea; anchors.bottom: parent.bottom }
        PropertyChanges { target: notificationArea; anchors.bottomMargin: 0 }
    }

    transitions: Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
    }
}




