import Qt 4.7

Rectangle {
    id: delegate

    signal delegateClicked(int index)

    width: delegate.ListView.view.width
    height: 40
    color: "white"

    ListHighlight {
        visible: (mouseArea.pressed) || ((index == 0) && (delegate.ListView.view.parent.pencilOn))
    }

    Rectangle {
        height: 1
        anchors { bottom: delegate.bottom; left: delegate.left; leftMargin: 10; right: delegate.right; rightMargin: 10 }
        color: _ACTIVE_COLOR_HIGH
        opacity: index == (delegate.ListView.view.count - 1) ? 0 : 0.5
    }

    Text {
        id: titleText

        elide: Text.ElideRight
        text: name
        color: "black"
        font.pixelSize: _STANDARD_FONT_SIZE
        anchors.fill: delegate
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    MouseArea {
        id: mouseArea

        anchors.fill: delegate
        onClicked: delegateClicked(index)
    }
}
