import QtQuick 1.0
import "scripts/menu.js" as Menu
import "scripts/createobject.js" as ObjectCreator

Rectangle {
    id: window

    signal goToPlaylist(string playlistId, string title)
//    signal playPlaylist(variant playlist)
    signal dialogClose

    function showPlaylistDialog(index) {
        toggleControls(false);
        var playlistDialog = ObjectCreator.createObject("PlaylistDialog.qml", window);
        playlistDialog.infoClicked.connect(getPlaylistInfo);
        playlistDialog.playClicked.connect(getPlaylistVideos);
        playlistDialog.close.connect(closeDialogs);
        playlistDialog.setPlaylist = playlistModel.get(index);
        playlists.state = "dim";
        playlistDialog.state = "show";
        mouseArea.enabled = true;
    }

    function getPlaylistInfo(playlistId, title) {
        goToPlaylist(playlistId, title);
        closeDialogs();
    }

    function getPlaylistVideos() {
        // TODO
    }

    function showNewPlaylistDialog() {
        toggleControls(false);
        var playlistDialog = ObjectCreator.createObject("NewPlaylistDialog.qml", window);
        playlistDialog.close.connect(closeDialogs);
        playlists.state = "dim";
        playlistDialog.state = "show";
        mouseArea.enabled = true;
    }

    function closeDialogs() {
        /* Close any open dialogs and return the window to its default state */

        dialogClose();
        playlists.state = "";
        mouseArea.enabled = false;
        toggleControls(true);
    }

    function toggleMenu() {
        Menu.toggleMenu();
    }

    color: _BACKGROUND_COLOR

    Connections {
        target:YouTube

        onPlaylistCreated: {
            displayMessage(qsTr("New playlist created"));
            playlistModel.reload();
        }
    }

    ListView {
        id: playlists

        anchors { fill: window; topMargin: 50 }
        boundsBehavior: Flickable.DragOverBounds
        highlightMoveDuration: 500
        preferredHighlightBegin: 0
        preferredHighlightEnd: 100
        highlightRangeMode: playlists.state == "" ? ListView.StrictlyEnforceRange : ListView.NoHighlightRange
        interactive: visibleArea.heightRatio < 1

        footer: Rectangle {
            id: footer
            width: playlists.width
            height: 100
            color: _BACKGROUND_COLOR
            visible: playlistModel.status == XmlListModel.Loading
            opacity: footer.visible ? 1 : 0

            BusyDialog {
                anchors.centerIn: footer
                opacity: footer.opacity
            }
        }

        model: playlistModel

        delegate: PlaylistDelegate {
            id: delegate

            Connections {
                onDelegateClicked: goToPlaylist(playlistModel.get(index).playlistId, playlistModel.get(index).title);
//                onDelegatePressed: showPlaylistDialog(index);
            }
        }

        Loader {
            id: menuLoader

            z: 20
            width: playlists.width / 2
            anchors { left: playlists.left; bottom: playlists.bottom; bottomMargin: 60 }

            onLoaded: menuLoader.item.addMenuItems([ { name: qsTr("New playlist") } ])

            Timer {
                id: menuTimer

                interval: 600
                onTriggered: menuLoader.source = ""
            }

            Connections {
                target: menuLoader.item

                onItemClicked: {
                    toggleMenu();
                    if (index == 0) {
                        showNewPlaylistDialog();
                    }
                }
            }
        }

        Text {
            anchors.centerIn: playlists
            font.pixelSize: _LARGE_FONT_SIZE
            font.bold: true
            color: "grey"
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            text: qsTr("No playlists found")
            visible: (playlistModel.status == XmlListModel.Ready) && (playlists.count == 0)
        }

        ScrollBar {}

        MouseArea {
            id: mouseArea
            anchors.fill: playlists
            enabled: false
            onClicked: closeDialogs()
        }

        states: State {
            name: "dim"
            PropertyChanges { target: playlists; opacity: 0.3 }
        }

        transitions: Transition {
            PropertyAnimation { properties: "opacity"; duration: 500 }
        }
    }

    states: State {
        name: "portrait"
        when: window.height > window.width
    }
}
