import QtQuick 1.0

Rectangle {
    id: menu

    property bool pencilOn : false

    signal itemClicked(int index)

    function addMenuItems(items) {
        for (var i = 0; i < items.length; i++) {
            menuModel.append(items[i]);
        }
    }

    height: 0
    z: 10
    color:  "white"
    border.width: 2
    border.color: _ACTIVE_COLOR_LOW
    radius: 5
    smooth: true
    visible: height > 0

    Component.onCompleted: menu.state = "show"

    Behavior on height { PropertyAnimation { properties: "height"; easing.type: Easing.OutQuart; duration: 500 } }

    ListView {
        id: menuList

        anchors { fill: menu; margins: 4 }
        clip: true
        interactive: false

        model: ListModel {
            id: menuModel
        }

        delegate: MenuDelegate {
            id: delegate

            Connections {
                onDelegateClicked: itemClicked(index)
            }
        }
    }

    states: State {
        name: "show"
        PropertyChanges { target: menu; height: (menuList.count * 40) + 10 }
    }
}
