import QtQuick 1.0

Item {
    id: dialog

    property alias message : message.text

    width: 180
    height: 60
    opacity: 0

    Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

    Rectangle {
        id: background

        anchors.fill: dialog
        color: _BACKGROUND_COLOR
        radius: 10
        opacity: 0.5
        border.color: _ACTIVE_COLOR_HIGH
        border.width: 2
    }

    Image {
        id: busyIndicator

        width: 40
        height: 40
        anchors { left: dialog.left; leftMargin: 10; verticalCenter: dialog.verticalCenter }
        source: "ui-images/busy.png"
        sourceSize.width: 40
        sourceSize.height: 40
        smooth: true

        NumberAnimation on rotation {
            running: dialog.opacity > 0; from: 0; to: 360; loops: Animation.Infinite; duration: 1000
        }
    }

    Text {
        id: message

        anchors { right: dialog.right; rightMargin: 10; verticalCenter: dialog.verticalCenter }
        font.pixelSize: _STANDARD_FONT_SIZE
        color: _TEXT_COLOR
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        smooth: true
        text: qsTr("Loading...")
    }
}
