import QtQuick 1.0
import "scripts/settings.js" as Settings
import "scripts/videolistscripts.js" as Scripts
import "scripts/menu.js" as Menu

Rectangle {
    id: window

//    signal playVideos(variant videos)

    function toggleMenu() {
        Menu.toggleMenu();
    }

    color: _BACKGROUND_COLOR

    Connections {
        target: Controller

        onAlert: displayMessage(message)
    }

    Loader {
        id: dialog

        anchors { top: window.bottom; topMargin: 10; horizontalCenter: window.horizontalCenter }
        z: 1
        onLoaded: {
            dialog.item.state = window.state;
            dialog.state = "show";
        }

        Timer {
            id: timer

            interval: 600
            onTriggered: dialog.source = ""
        }

        states: [
            State {
                name: "show"
                AnchorChanges { target: dialog; anchors { top: undefined; verticalCenter: window.verticalCenter } }
            }
        ]

        transitions: [
            Transition {
                AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
            }
        ]
    }

    Item {
        id: dimmer

        anchors.fill: window

        Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

        Loader {
            id: menuLoader

            property bool pencilOn : false

            z: 20
            width: dimmer.width / 2
            anchors { left: dimmer.left; bottom: dimmer.bottom; bottomMargin: 60 }

            onLoaded: {
                menuLoader.item.pencilOn = menuLoader.pencilOn;
                menuLoader.item.addMenuItems([ { name: qsTr("Multi-select") } ]);
                if (videoList.checkList.length > 0) {
                    menuLoader.item.addMenuItems([ { name: qsTr("Delete from archive") }, { name: qsTr("Delete from device") } ])
                }
            }

            onPencilOnChanged: {
                menuLoader.item.pencilOn = menuLoader.pencilOn;
                if (!menuLoader.pencilOn) {
                    videoList.checkList = [];
                }
            }

            Timer {
                id: menuTimer

                interval: 600
                onTriggered: menuLoader.source = ""
            }

            Connections {
                target: menuLoader.item

                onItemClicked: {
                    toggleMenu();
                    if ((index == 1) || (index == 2)) {
                        for (var i = 0; i < videoList.checkList.length; i++) {
                            var video = archiveModel.get(videoList.checkList[i]);
                            if (index == 2) {
                                Controller.deleteVideo(video.filePath);
                            }
                            Settings.deleteVideoFromArchive(video.filePath);
                            archiveModel.remove(videoList.checkList[i]);
                        }
                    }
                    menuLoader.pencilOn = !menuLoader.pencilOn;
                }
            }
        }

        Text {
            anchors.centerIn: dimmer
            font.pixelSize: _LARGE_FONT_SIZE
            font.bold: true
            color: "grey"
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            text: "No videos in archive"
            visible: videoList.count == 0
        }

        ListView {
            id: videoList

            property variant checkList : []

            anchors { fill: dimmer; topMargin: 50 }
            snapMode: ListView.SnapToItem
            boundsBehavior: Flickable.DragOverBounds
            highlightMoveDuration: 500
            preferredHighlightBegin: 0
            preferredHighlightEnd: 100
            highlightRangeMode: ListView.StrictlyEnforceRange
            cacheBuffer: 2500
            interactive: visibleArea.heightRatio < 1

            Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

            model: archiveModel

            onCountChanged: positionViewAtIndex(0, ListView.Beginning)

            delegate: ArchiveDelegate {
                id: delegate

                function checkOrPlayVideo() {
                    if (menuLoader.pencilOn) {
                        var cl = videoList.checkList;
                        if (!delegate.checked) {
                            cl.push(index);
                        }
                        else {
                            for (var i = 0; i < cl.length; i++) {
                                if (cl[i] == index) {
                                    cl.splice(i, 1);
                                }
                            }
                        }
                        videoList.checkList = cl;
                    }
                    else {
                        Controller.playVideo(archiveModel.get(index).filePath) //playVideos([ archiveModel.get(index) ]);
                    }
                }

                Connections {
                    onDelegateClicked: checkOrPlayVideo()
                }

                checked: Scripts.indexInCheckList(index)
            }

            ScrollBar {}
        }

        MouseArea {
            id: mouseArea

            anchors { fill: dimmer; topMargin: 50 }
            enabled: false
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.3 }
        }

    }

    states: State {
        name: "portrait"
        when: window.height > window.width
    }
}
