import Qt 4.7
import "scripts/menu.js" as Menu
import "scripts/createobject.js" as ObjectCreator

Rectangle {
    id: window

    signal goToUserVideos(string username)
    signal goToNewSubVideos(string feed, string title)
    signal dialogClose

    property string latestSubVideosFeed : "http://gdata.youtube.com/feeds/api/users/" + YouTube.currentUser + "/newsubscriptionvideos?v=2&max-results=50"

    function showUserInfoDialog(index) {
        /* Show the accounts dialog */

        if (subscriptionsList.state == "") {
            toggleControls(false);
            var userDialog = ObjectCreator.createObject("UserInfoDialog.qml", window);
            userDialog.getUserProfile(subscriptionsModel.get(index), true);
            userDialog.userVideosClicked.connect(goToUserVideos);
            userDialog.close.connect(closeDialogs);
            subscriptionsList.state = "dim";
            userDialog.state = "show";
            mouseArea.enabled = true;
        }
    }

    function closeDialogs() {
        /* Close any open dialogs and return the window to its default state */

        dialogClose();
        subscriptionsList.state = "";
        mouseArea.enabled = false;
        toggleControls(true);
    }

    function toggleMenu() {
        Menu.toggleMenu();
    }

    color: backgroundColor

    Connections {
        target: YouTube

        onUnsubscribed: {
            displayMessage(qsTr("You have unsubscribed to '") + username + "'");
        }
    }

    ListView {
        id: subscriptionsList

        anchors { fill: window; topMargin: 50 }
        boundsBehavior: Flickable.DragOverBounds
        highlightMoveDuration: 500
        preferredHighlightBegin: 0
        preferredHighlightEnd: 100
        highlightRangeMode: ListView.StrictlyEnforceRange
        interactive: visibleArea.heightRatio < 1

        footer: Rectangle {
            id: footer
            width: subscriptionsList.width
            height: 100
            color: backgroundColor
            visible: subscriptionsModel.status == XmlListModel.Loading
            opacity: footer.visible ? 1 : 0

            BusyDialog {
                anchors.centerIn: footer
                opacity: footer.opacity
            }
        }

        model: subscriptionsModel

        ScrollBar {}

        MouseArea {
            id: mouseArea
            anchors.fill: subscriptionsList
            enabled: false
            onClicked: closeDialogs()
        }

        delegate: SubscriptionDelegate {
            id: delegate

            Connections {
                onDelegateClicked: {
                    var username = subscriptionsModel.get(index).title;
                    goToUserVideos(username);
                }
                onDelegatePressed: showUserInfoDialog(index);
            }
        }

        Loader {
            id: menuLoader

            z: 20
            width: subscriptionsList.width / 2
            anchors { left: subscriptionsList.left; bottom: subscriptionsList.bottom; bottomMargin: 60 }

            onLoaded: menuLoader.item.addMenuItems([ { name: qsTr("Latest Subscription Videos") } ])

            Timer {
                id: menuTimer

                interval: 600
                onTriggered: menuLoader.source = ""
            }

            Connections {
                target: menuLoader.item

                onItemClicked: {
                    toggleMenu();
                    if (index == 0) {
                        goToNewSubVideos(latestSubVideosFeed, qsTr("Latest Subscription Videos"))
                    }
                }
            }
        }

        Text {
            anchors.centerIn: subscriptionsList
            font.pixelSize: largeFontSize
            font.bold: true
            color: "grey"
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            text: qsTr("No subscriptions found")
            visible: (subscriptionsModel.status == XmlListModel.Ready) && (subscriptionsList.count == 0)
        }

        states: [
            State {
                name: "dim"
                PropertyChanges { target: subscriptionsList; opacity: 0.3 }
            }
        ]
        transitions: [
            Transition {
                PropertyAnimation { properties: "opacity"; duration: 500 }
            }
        ]
    }

    states: State {
        name: "portrait"
        when: window.height > window.width
    }
}
