/* Video info functions */

function getDuration(secs) {
    /* Convert seconds to HH:MM:SS format. */

    var hours = Math.floor(secs / 3600);
    var minutes = Math.floor(secs / 60) - (hours * 60);
    var seconds = secs - (hours * 3600) - ( minutes * 60);
    if (seconds < 10) {
        seconds = "0" + seconds;
    }
    var duration = minutes + ":" + seconds;
    if (hours > 0) {
        duration = hours + ":" + duration;
    }
    return duration;
}

function showPlaylistDialog() {
    if (dialog.source == "") {
        dialog.source = "AddToPlaylistDialog.qml";
        dialog.item.playlistClicked.connect(addVideoToPlaylist);
        dimmer.state = "dim";
        mouseArea.enabled = true;
    }
}

function addVideoToPlaylist(playlistId) {
    YouTube.addToPlaylist(videoId, playlistId);
    closeDialogs();
}

function shareVideo(service) {
    if (dialog.source == "") {
        if (service == "Twitter") {
            checkTwitterAccess(videoId);
        }
        else if (service == "Facebook") {
            checkFacebookAccess(videoId);
        }
    }
}

function showAddCommentDialog() {
    /* Add a new comment */

    if (dialog.source == "") {
        dialog.source = "AddCommentDialog.qml";
        dialog.item.setService("YouTube", videoId)
        dialog.item.close.connect(closeDialogs);
        dimmer.state = "dim";
        mouseArea.enabled = true;
    }
}

function rotateDialogs() {
    if (dialog.source != "") {
        dialog.item.state = window.state;
    }
}

function closeDialogs() {
    /* Close any open dialogs and return the window to its default state */

    dialog.state = "";
    closeOAuth();
    timer.running = true;
    dimmer.state = "";
    mouseArea.enabled = false;
}

function checkFacebookAccess() {
    if (Sharing.facebookToken != "unknown") {
        dialog.source = "AddCommentDialog.qml";
        dialog.item.setService("Facebook", videoId)
        dialog.item.close.connect(closeDialogs);
        dimmer.state = "dim";
        mouseArea.enabled = true;
    }
    else {
        getFacebookAccessToken();
    }
}

function getFacebookAccessToken() {

    Qt.include("createobject.js");
    var oauthDialog = createObject("OAuthDialog.qml", window);
    oauthDialog.setService("Facebook");
    oauthDialog.authorised.connect(checkFacebookAccess);
    oauthDialog.state = "show";
    dimmer.state = "dim";
    mouseArea.enabled = true;
}
