import Qt 4.7
import "scripts/videolistscripts.js" as Scripts
import "scripts/menu.js" as Menu

Rectangle {
    id: window

    property string videoFeed

    signal goToVideo(variant video)
    //    signal playVideos(variant videos)

    function setVideoFeed(feed) {
        videoFeed = feed;
        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                var xml = doc.responseText;
                videoListModel.setXml(xml);
            }
        }
        doc.open("GET", feed);
        if (YouTube.currentUser != "") {
            doc.setRequestHeader("Authorization", "GoogleLogin auth=" + YouTube.accessToken);
        }
        doc.send();
    }

    function toggleMenu() {
        Menu.toggleMenu();
    }

    color: backgroundColor
    onStateChanged: Scripts.rotateDialogs()

    Loader {
        id: dialog

        anchors { top: window.bottom; topMargin: 10; horizontalCenter: window.horizontalCenter }
        z: 1
        onLoaded: {
            dialog.item.state = window.state;
            dialog.state = "show";
        }

        Timer {
            id: timer

            interval: 600
            onTriggered: dialog.source = ""
        }

        states: [
            State {
                name: "show"
                AnchorChanges { target: dialog; anchors { top: undefined; verticalCenter: window.verticalCenter } }
            }
        ]

        transitions: [
            Transition {
                AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
            }
        ]
    }

    Item {
        id: dimmer

        anchors.fill: window

        Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

        Loader {
            id: menuLoader

            property bool pencilOn : false

            z: 20
            width: dimmer.width / 2
            anchors { left: dimmer.left; bottom: dimmer.bottom; bottomMargin: 60 }

            onLoaded: {
                menuLoader.item.pencilOn = menuLoader.pencilOn;
                menuLoader.item.addMenuItems([ { name: qsTr("Multi-select") } ]);
                if (menuLoader.pencilOn) {
                    menuLoader.item.addMenuItems([ { name: qsTr("Download video") }, { name: qsTr("Download audio") },
                                                  { name: qsTr("Add to favourites") }, { name: qsTr("Add to playlist") }, { name: qsTr("Copy to clipboard") } ])
                }
            }

            onPencilOnChanged: menuLoader.item.pencilOn = menuLoader.pencilOn

            Timer {
                id: menuTimer

                interval: 600
                onTriggered: menuLoader.source = ""
            }

            Connections {
                target: menuLoader.item

                onItemClicked: {
                    toggleMenu();
                    if (index == 0) {
                        videoList.checkList = [];
                    }
                    else if (index == 1) {
                        Scripts.addVideosToDownloads(false);
                    }
                    else if (index == 2) {
                        Scripts.addVideosToDownloads(true);
                    }
                    else if (index == 3) {
                        if (userIsSignedIn()) {
                            Scripts.addVideosToFavourites();
                        }
                    }
                    else if (index == 4) {
                        if (userIsSignedIn()) {
                            Scripts.showPlaylistDialog();
                        }
                    }
                    else if (index == 5) {
                        Scripts.copyVideosToClipboard();
                    }
                    menuLoader.pencilOn = !menuLoader.pencilOn;
                }
            }
        }

        Text {
            id: noResultsText

            anchors.centerIn: dimmer
            font.pixelSize: largeFontSize
            font.bold: true
            color: "grey"
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            text: qsTr("No videos found")
            visible: (videoListModel.status == XmlListModel.Ready) && (videoListModel.count == 0)
        }

        ListView {
            id: videoList

            property variant checkList : []

            anchors { fill: dimmer; topMargin: 50 }
            boundsBehavior: Flickable.DragOverBounds
            highlightMoveDuration: 500
            preferredHighlightBegin: 0
            preferredHighlightEnd: 100
            highlightRangeMode: ListView.StrictlyEnforceRange
            cacheBuffer: 2500
            interactive: visibleArea.heightRatio < 1

            footer: Rectangle {
                id: footer

                width: videoList.width
                height: 100
                color: backgroundColor
                visible: videoListModel.status == XmlListModel.Loading
                opacity: footer.visible ? 1 : 0

                BusyDialog {
                    anchors.centerIn: footer
                    opacity: footer.opacity
                }
            }

            Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

            model: VideoListModel {
                id: videoListModel
            }
            onCurrentIndexChanged: {
                if ((videoList.count - videoList.currentIndex == 15)
                        && (videoList.count < videoListModel.totalResults)
                        && (videoListModel.status == XmlListModel.Ready)) {
                    Scripts.appendVideoFeed();
                }
            }

            delegate: VideoListDelegate {
                id: delegate

                function checkOrGoToVideo() {
                    if (menuLoader.pencilOn) {
                        var cl = videoList.checkList;
                        if (!delegate.checked) {
                            cl.push(index);
                        }
                        else {
                            for (var i = 0; i < cl.length; i++) {
                                if (cl[i] == index) {
                                    cl.splice(i, 1);
                                }
                            }
                        }
                        videoList.checkList = cl;
                    }
                    else {
                        goToVideo(videoListModel.get(index));
                    }
                }

                checked: Scripts.indexInCheckList(index)

                Connections {
                    onDelegateClicked: checkOrGoToVideo()
                    onDelegatePressed: Scripts.showVideoDialog(index);
                }
            }

            ScrollBar {}
        }

        MouseArea {
            id: mouseArea

            anchors { fill: dimmer; topMargin: 50 }
            enabled: false
            onClicked: Scripts.closeDialogs()
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.3 }
        }

    }

    states: State {
        name: "portrait"
        when: window.height > window.width
    }
}
