import Qt 4.7

Item {
    id: dialog

    property alias message : message.text

    width: 180
    height: 60
    opacity: 0

    Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

    Rectangle {
        id: background

        anchors.fill: dialog
        color: "black"
        radius: 10
        opacity: 0.5
        border.color: activeColor
        border.width: 2
    }

    Image {
        id: busyIndicator

        width: 40
        height: 40
        anchors { left: dialog.left; leftMargin: 10; verticalCenter: dialog.verticalCenter }
        source: "ui-images/busy.png"
        sourceSize.width: 40
        sourceSize.height: 40
        smooth: true

        NumberAnimation on rotation {
            running: dialog.opacity > 0; from: 0; to: 360; loops: Animation.Infinite; duration: 1000
        }
    }

    Text {
        id: message

        anchors { right: dialog.right; rightMargin: 10; verticalCenter: dialog.verticalCenter }
        font.pixelSize: standardFontSize
        color: "white"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        smooth: true
        text: qsTr("Loading...")
    }
}
