import Qt 4.7
import "settings.js" as Settings

Item {
    id: dialog

    property string titleText

    signal settingChosen(string setting)
    signal close

    function setSettingsList(title, list, currentSetting) {
        /* Set the title and populate the settings model */
        titleText = title;
        for (var i = 0; i < list.length; i++) {
            settingsModel.append({ "setting": list[i] });
            if (list[i] == currentSetting) {
                settingsList.currentIndex = i;
            }
        }
    }

    function resetDialog() {
        /* Reset the dialog to its default state */
        if (opacity == 0) {
            settingsModel.clear();
        }
    }

    width: 600
    height: 300
    opacity: 0

    onOpacityChanged: resetDialog()

    Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

    Rectangle {
        id: background

        anchors.fill: dialog
        color: "black"
        opacity: 0.5
        radius: 10
        border.width: 2
        border.color: activeColor
    }

    Text {
        id: title

        anchors { horizontalCenter: dialog.horizontalCenter; top: dialog.top; topMargin: 10 }
        text: titleText
        font.pixelSize: smallFontSize
        color: "white"
    }

    CloseButton {
        id: closeButton

        onButtonClicked: {
            dialog.opacity = 0;
            close();
        }
    }

    ListView {
        id: settingsList

        anchors { fill: dialog; leftMargin: 10; rightMargin: 10; topMargin: 55; bottomMargin: 10 }
        clip: true
        interactive: visibleArea.heightRatio < 1

        model: ListModel {
            id: settingsModel
        }

        delegate: SettingsDelegate {
            id: delegate

            Connections {
                onDelegateClicked: {
                    settingsList.currentIndex = index;
                    settingChosen(setting);
                    dialog.opacity = 0;
                    close();
                }
            }
        }

        ScrollBar {}
    }

    MouseArea {
        z: -1
        anchors.fill: dialog
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: dialog; width: 460; height: 420 }
    }
}
