import QtQuick 1.0

Rectangle {
    id: delegate

    signal delegateClicked
    signal delegatePressed

    width: parent.width
    height: 101
    color: "black"

    ListHighlight {
        visible: mouseArea.pressed
    }

    Text {
        id: titleText

        elide: Text.ElideRight
        text: title
        color: "white"
        font.pixelSize: standardFontSize
        anchors.fill: parent
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    Text {
        elide: Text.ElideRight
        text: videoCount + qsTr(" videos")
        color: "grey"
        font.pixelSize: smallFontSize
        anchors.rightMargin: 5
        anchors.fill: parent
        horizontalAlignment: Text.AlignRight
        verticalAlignment: Text.AlignVCenter
    }

    Rectangle {
        height: 1
        anchors { bottom: delegate.bottom; left: delegate.left; leftMargin: 10; right: delegate.right; rightMargin: 10 }
        color: activeColor
        opacity: 0.5
        visible: !(index == delegate.ListView.view.count - 1)
    }

    MouseArea {
        id: mouseArea

        anchors.fill: delegate
        onClicked: delegateClicked()
        onPressAndHold: delegatePressed()
    }
}
