import QtQuick 1.0

Rectangle {
    id: delegate

    signal commentClicked(string author)

    width: delegate.ListView.view.width;
    height: authorText.height + commentText.height + 20
    color: "black"

    Text {
        id: authorText

        width: delegate.width
        height: 30
        anchors { top: delegate.top; left: delegate.left; margins: 10 }
        font.pixelSize: smallFontSize
        color: "white"
        text: mouseArea.pressed ? qsTr("By ") + "<font color='" + activeColor + "'>"
                                  + author + "</font> on " + date.split("T")[0]
                                : qsTr("By ") + "<font color='" + activeColorLow + "'>"
                                  + author + "</font> on " + date.split("T")[0]

        MouseArea {
            id: mouseArea

            anchors.fill: authorText
            onClicked: commentClicked(author);
        }
    }

    Text {
        id: commentText

        width: delegate.width - 10
        anchors {top: authorText.bottom; left: authorText.left }
        wrapMode: TextEdit.WordWrap
        font.pixelSize: smallFontSize
        color: "grey"
        text: comment
    }

    Rectangle {
        height: 1
        anchors { bottom: delegate.bottom; left: delegate.left; leftMargin: 10; right: delegate.right; rightMargin: 10 }
        color: activeColor
        opacity: 0.5
        visible: !(index == delegate.ListView.view.count - 1)
    }
}
