import QtQuick 1.0

Item {
    id: dialog

    width: 400
    height: 210

    Rectangle {
        id: background

        anchors.fill: dialog
        color: "black"
        opacity: 0.5
        radius: 10
        border.width: 2
        border.color: activeColor
    }

    Image {
        id: icon

        width: 64
        height: 64
        anchors { top: background.top; topMargin: 10; horizontalCenter: background.horizontalCenter }
        smooth: true
        source: "ui-images/cutetubehires.png"
    }

    Text {
        id: title

        anchors { top: icon.bottom; topMargin: 10; horizontalCenter: background.horizontalCenter }
        color: "white"
        font { pixelSize: 24; bold: true }
        text: "cuteTube-QML - 0.3.7"
    }

    Text {
        id: description

        anchors { top: title.bottom; left: background.left; right: background.right; margins: 10 }
        color: "white"
        font.pixelSize: smallFontSize
        wrapMode: TextEdit.WordWrap
        horizontalAlignment: TextEdit.AlignHCenter
        text: "A feature-rich YouTube client for the Nokia N900. This is an experimental release using QML."
    }

    MouseArea {
        z: -1
        anchors.fill: dialog
    }
}
