#ifndef CONTROLLER_H
#define CONTROLLER_H

#include <QObject>
#include <QProcess>

class QWidget;

#include "qmlapplicationviewer.h"

class Controller : public QObject {
    Q_OBJECT

public:
    explicit Controller(QObject *parent = 0);

    void setView(QmlApplicationViewer* view);

public slots:

    void setOrientation(const QString &orient);
    bool kmPlayerInstalled();
    bool xTubeInstalled();
    void setMediaPlayer(const QString &player);
    void toggleState();
    void minimize();
    void playVideo(const QString &url);
    void deleteVideo(const QString &path);
    void convertToAudio(const QString &input);
    QString archiveFileExists(const QString &filePath, const QString &archivePath);
    bool pathExists(const QString &path);

private slots:
    void conversionFinished(int exitCode, QProcess::ExitStatus exitStatus);
//    void setWindowGeometry();

private:
    QmlApplicationViewer *m_view;
    QString mediaPlayer;
    QProcess *converter;
    QString inputFile;
    QString outputFile;

signals:
    void alert(const QString &message);
    void conversionStarted();
    void conversionCompleted();
    void conversionFailed();
};

#endif // CONTROLLER_H
