import QtQuick 1.0
import "settings.js" as Settings

Item {
    id: dialog

    signal close
    signal accountSaved

    function getAccountDetails(username) {
        /* Retrieve the username and password */

        title.text = "Edit Account"
        var account = Settings.getAccount(username);
        usernameInput.text = account[0];
        passwordInput.text = account[1];
        checkbox.checked = (account[2] == 1);
    }

    function resetDialog() {
        /* Reset title and text input fields */

        if (dialog.opacity == 0) {
            title.text = "New Account";
            usernameInput.text = "";
            passwordInput.text = "";
            checkbox.checked = true;
        }
    }

    function saveAccount() {
        /* Save the account to the database and sign in to YouTube */

        var isDefault = checkbox.checked ? 1 : 0;
        var username = usernameInput.text;
        var password = passwordInput.text;
        var result = Settings.addOrEditAccount(username, password, isDefault);
        if (result == "OK") {
            toggleBusy(true);
            YouTube.login(username, password);
            accountSaved();
        }
        else {
            displayMessage("Database error. Unable to save account");
        }
        dialog.opacity = 0;
        close();
    }

    width: 600
    height: 295
    opacity: 0

    Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

    onOpacityChanged: resetDialog()

    Rectangle {
        id: background

        anchors.fill: dialog
        color: "black"
        opacity: 0.5
        radius: 10
        border.width: 2
        border.color: activeColor
    }

    Text {
        id: title

        anchors { horizontalCenter: dialog.horizontalCenter; top: dialog.top; topMargin: 10 }
        font.pixelSize: smallFontSize
        color: "white"
        text: "New Account"
    }

    Column {
        id: column

        anchors { left: dialog.left; leftMargin: 10; right: dialog.right; rightMargin: 180; top: dialog.top; topMargin: 50 }
        spacing: 10

        Text {
            font.pixelSize: smallFontSize
            color: "grey"
            text: "Username"
        }

        Rectangle {
            height: 50
            width: column.width
            color:  "white"
            border.width: 2
            border.color: activeColorLow
            radius: 5

            TextInput {
                id: usernameInput

                anchors { fill: parent; margins: 2 }
                focus: true
                font.pixelSize: standardFontSize
                selectByMouse: true
                selectionColor: activeColorLow
            }
        }

        Text {
            font.pixelSize: smallFontSize
            color: "grey"
            text: "Password"
        }

        Rectangle {
            height: 50
            width: column.width
            color:  "white"
            border.width: 2
            border.color: activeColorLow
            radius: 5

            TextInput {
                id: passwordInput

                anchors { fill: parent; margins: 2 }
                font.pixelSize: standardFontSize
                selectByMouse: true
                selectionColor: activeColorLow
                echoMode: TextInput.Password
            }
        }

        Text {
            font.pixelSize: smallFontSize
            color: "grey"
            text: "Default?"

            CheckBox {
                id: checkbox

                anchors { left: parent.right; leftMargin: 10 }
            }
        }
    }

    CloseButton {
        id: closeButton

        onButtonClicked: {
            dialog.opacity = 0;
            close();
        }
    }

    PushButton {
        id: saveButton

        anchors { right: dialog.right; bottom: dialog.bottom; margins: 10 }
        icon: "ui-images/tick.png"

        Connections {
            onButtonClicked: {
                if (usernameInput.text != "" && passwordInput.text != "") {
                    saveAccount();
                }
            }
        }
    }

    MouseArea {
        z: -1
        anchors.fill: dialog
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: dialog; width: 460; height: 385 }
        PropertyChanges { target: column; anchors.rightMargin: 10 }
        PropertyChanges { target: saveButton; buttonWidth: 440 }
    }
}
